/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import net.thucydides.core.model.DataTableRow;
import net.thucydides.core.model.TestResult;

public class DataTable {
    private final List<String> headers;
    private final List<DataTableRow> rows;
    private final boolean predefinedRows;
    private AtomicInteger currentRow = new AtomicInteger(0);
    private static final List<DataTableRow> NO_ROWS = Lists.newArrayList();

    private DataTable(List<String> headers, List<DataTableRow> rows) {
        this.headers = headers;
        this.rows = new CopyOnWriteArrayList<DataTableRow>(rows);
        this.predefinedRows = !rows.isEmpty();
    }

    public static DataTableBuilder withHeaders(List<String> headers) {
        return new DataTableBuilder(headers);
    }

    public List<String> getHeaders() {
        return ImmutableList.copyOf(this.headers);
    }

    public List<DataTableRow> getRows() {
        return ImmutableList.copyOf(this.rows);
    }

    public RowValueAccessor row(int rowNumber) {
        return new RowValueAccessor(this, rowNumber);
    }

    public RowValueAccessor nextRow() {
        return new RowValueAccessor(this, this.nextRowNumber());
    }

    public boolean atLastRow() {
        return this.rows.isEmpty() || this.currentRow.get() == this.rows.size() - 1;
    }

    public RowValueAccessor currentRow() {
        return new RowValueAccessor(this, this.currentRowNumber());
    }

    private int nextRowNumber() {
        return this.currentRow.incrementAndGet();
    }

    private int currentRowNumber() {
        return this.currentRow.intValue();
    }

    public void addRow(Map<String, ? extends Object> data) {
        this.addRow(new DataTableRow((List)ImmutableList.copyOf(data.values())));
    }

    public void addRow(DataTableRow dataTableRow) {
        this.rows.add(dataTableRow);
        this.currentRow.set(this.rows.size() - 1);
    }

    public void addRows(List<DataTableRow> rows) {
        for (DataTableRow row : rows) {
            DataTableRow newRow = new DataTableRow((List)ImmutableList.copyOf((Collection)row.getValues()));
            newRow.setResult(row.getResult());
            this.rows.add(newRow);
        }
        this.currentRow.set(rows.size() - 1);
    }

    public boolean hasPredefinedRows() {
        return this.predefinedRows;
    }

    public int getSize() {
        return this.rows.size();
    }

    public class RowValueAccessor {
        private final DataTable dataTable;
        private final int rowNumber;

        public RowValueAccessor(DataTable dataTable2, int rowNumber) {
            this.dataTable = dataTable2;
            this.rowNumber = rowNumber;
        }

        public void hasResult(TestResult result) {
            ((DataTableRow)this.dataTable.rows.get(this.rowNumber)).updateResult(result);
        }

        public Map<String, String> toStringMap() {
            HashMap<String, String> rowData = new HashMap<String, String>();
            int i = 0;
            for (Object value : ((DataTableRow)this.dataTable.rows.get(this.rowNumber)).getValues()) {
                rowData.put((String)this.dataTable.headers.get(i), value.toString());
                ++i;
            }
            return rowData;
        }
    }

    public static class DataTableBuilder {
        final List<String> headers;
        final List<DataTableRow> rows;

        public DataTableBuilder(List<String> headers) {
            this(headers, NO_ROWS);
        }

        public DataTableBuilder(List<String> headers, List<DataTableRow> rows) {
            this.headers = headers;
            this.rows = rows;
        }

        public DataTableBuilder andCopyRowDataFrom(DataTableRow row) {
            ArrayList<DataTableRow> rows = new ArrayList<DataTableRow>();
            rows.add(new DataTableRow(row.getValues()));
            return new DataTableBuilder(this.headers, rows);
        }

        public DataTable build() {
            return new DataTable(this.headers, this.rows);
        }

        public DataTableBuilder andRows(List<List<Object>> rows) {
            return new DataTableBuilder(this.headers, Lambda.convert(rows, this.toDataTableRows()));
        }

        public DataTableBuilder andRowData(List<DataTableRow> rows) {
            return new DataTableBuilder(this.headers, rows);
        }

        public DataTableBuilder andMappedRows(List<? extends Map<String, ? extends Object>> mappedRows) {
            ArrayList rowData = Lists.newArrayList();
            for (Map<String, ? extends Object> map : mappedRows) {
                rowData.add(this.rowDataFrom(map));
            }
            return new DataTableBuilder(this.headers, Lambda.convert((Object)rowData, this.toDataTableRows()));
        }

        private Converter<List<Object>, DataTableRow> toDataTableRows() {
            return new Converter<List<Object>, DataTableRow>(){

                public DataTableRow convert(List<Object> cellValues) {
                    return new DataTableRow(cellValues);
                }
            };
        }

        private List<Object> rowDataFrom(Map<String, ? extends Object> mappedRow) {
            ArrayList rowData = Lists.newArrayList();
            for (String header : this.headers) {
                rowData.add(mappedRow.get(header));
            }
            return rowData;
        }
    }
}

