/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.thucydides.core.annotations.Narrative;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reflection.ClassFinder;
import net.thucydides.core.requirements.AbstractRequirementsTagProvider;
import net.thucydides.core.requirements.CachedReq;
import net.thucydides.core.requirements.ChildrenFirstOrderedMap;
import net.thucydides.core.requirements.Req;
import net.thucydides.core.requirements.RequirementPersister;
import net.thucydides.core.requirements.RequirementsTagProvider;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.SystemPropertiesConfiguration;

public class AnnotationBasedTagProvider
extends AbstractRequirementsTagProvider
implements RequirementsTagProvider {
    private static final String DOT_REGEX = "\\.";
    private List<Requirement> requirements;
    private final Configuration configuration;
    private final RequirementPersister persister;
    private final CachedReq cachedReq;

    public AnnotationBasedTagProvider() {
        this((EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    public AnnotationBasedTagProvider(EnvironmentVariables vars) {
        super(vars);
        this.configuration = new SystemPropertiesConfiguration(this.environmentVariables);
        this.persister = new RequirementPersister(this.configuration.getOutputDirectory(), this.rootDirectory);
        this.cachedReq = new CachedReq(this.rootDirectory);
        this.initialize();
    }

    private synchronized void initialize() {
        if (this.cachedReq.get() == null) {
            List<Class<?>> classes = ClassFinder.loadClasses().annotatedWith(Narrative.class).fromPackage(this.rootDirectory);
            SortedMap<String, Req> map = classes.isEmpty() ? this.persister.read() : this.initializeReqMapFromPackageAnnotations(classes);
            this.cachedReq.set(map);
        }
        if (this.requirements == null) {
            this.initializeRequirementsFromReqMap();
        }
    }

    private void initializeRequirementsFromReqMap() {
        SortedMap<String, Req> map = this.cachedReq.get();
        this.requirements = new ArrayList<Requirement>();
        for (Map.Entry e : map.entrySet()) {
            Req req = (Req)e.getValue();
            TreeMap<String, Requirement> children = new TreeMap<String, Requirement>();
            for (Req r : req.getChildren()) {
                children.put(r.getName(), r.getRequirement());
            }
            Requirement requirement = this.toRequirement(req, children);
            ((Req)e.getValue()).setRequirement(requirement);
            if (((String)e.getKey()).contains(".")) continue;
            this.requirements.add(requirement);
        }
    }

    private Requirement toRequirement(Req req, Map<String, Requirement> children) {
        return Requirement.named(this.humanReadableVersionOf(req.getName())).withOptionalDisplayName(req.getPublicName() == null || "".equals(req.getPublicName()) ? this.humanReadableVersionOf(req.getName()) : req.getPublicName()).withOptionalCardNumber(req.getCardNumber()).withType(this.getType(req)).withNarrativeText(req.getNarrativeText()).withChildren(new ArrayList<Requirement>(children.values()));
    }

    private SortedMap<String, Req> initializeReqMapFromPackageAnnotations(Collection<Class<?>> classes) {
        ChildrenFirstOrderedMap map = new ChildrenFirstOrderedMap();
        for (Class<?> p : classes) {
            Narrative n = p.getAnnotation(Narrative.class);
            String name = p.getName().replace(this.rootDirectory + ".", "").replace("package-info", "");
            String[] names = name.split(DOT_REGEX);
            String parentPackage = null;
            String currentPackage = "";
            for (int i = 0; i < names.length; ++i) {
                Req parentRequirement;
                currentPackage = currentPackage + names[i];
                Req r = (Req)map.get(currentPackage);
                Req req = parentRequirement = parentPackage == null ? null : (Req)map.get(parentPackage);
                if (i == names.length - 1) {
                    r = new Req(i, names[i], n.title(), n.cardNumber(), n.type(), Joiner.on((String)"\n").join((Object[])n.text()), r == null ? new ArrayList() : r.getChildren());
                    r.setAnnotatedClass(!p.getName().endsWith("package-info"));
                } else if (r == null) {
                    r = new Req(names[i], names[i], i);
                }
                if (parentRequirement != null) {
                    parentRequirement.getChildren().add(r);
                }
                map.put(currentPackage, r);
                parentPackage = currentPackage;
                currentPackage = currentPackage + ".";
            }
        }
        this.persister.write(map);
        return map;
    }

    private String getType(Req req) {
        String type = req.getType();
        if (req.isAnnotatedClass()) {
            type = "story";
        } else if (req.getType() == null || "".equals(req.getType())) {
            type = this.getDefaultType(req.getLevel());
        }
        return type;
    }

    @Override
    public List<Requirement> getRequirements() {
        return this.requirements;
    }

    @Override
    public Optional<Requirement> getParentRequirementOf(TestOutcome testOutcome) {
        if (testOutcome.getUserStory() == null || testOutcome.getUserStory().getUserStoryClass() == null || testOutcome.getUserStory().getUserStoryClass().getName() == null) {
            return Optional.absent();
        }
        String name = testOutcome.getUserStory().getUserStoryClass().getName().replace(this.rootDirectory + ".", "");
        this.getRequirements();
        Req req = (Req)this.cachedReq.get().get(name);
        if (req != null) {
            return Optional.of((Object)req.getRequirement());
        }
        return Optional.absent();
    }

    @Override
    public Optional<Requirement> getRequirementFor(TestTag testTag) {
        Preconditions.checkNotNull((Object)testTag.getName());
        Preconditions.checkNotNull((Object)testTag.getType());
        Optional result = Optional.absent();
        for (Req req : this.cachedReq.get().values()) {
            if (!req.getRequirement().asTag().equals(testTag)) continue;
            return Optional.of((Object)req.getRequirement());
        }
        return result;
    }

    @Override
    public Set<TestTag> getTagsFor(TestOutcome testOutcome) {
        HashSet<TestTag> result = new HashSet<TestTag>();
        if (testOutcome.getPath() != null) {
            for (Req req : this.cachedReq.get().values()) {
                result.add(TestTag.withName(this.humanReadableVersionOf(req.getName())).andType(this.getType(req)));
            }
        }
        return result;
    }
}

