/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.requirements.FileSystemRequirementsTagProvider;
import net.thucydides.core.requirements.RequirementsProviderService;
import net.thucydides.core.requirements.RequirementsTagProvider;
import net.thucydides.core.statistics.service.ClasspathTagProviderService;
import net.thucydides.core.statistics.service.TagProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathRequirementsProviderService
implements RequirementsProviderService {
    private final Logger logger = LoggerFactory.getLogger(ClasspathRequirementsProviderService.class);
    private ClasspathTagProviderService tagProviderService;
    private List<RequirementsTagProvider> requirementsTagProviders;

    @Inject
    public ClasspathRequirementsProviderService(ClasspathTagProviderService tagProviderService) {
        this.tagProviderService = tagProviderService;
    }

    @Override
    public List<RequirementsTagProvider> getRequirementsProviders() {
        if (this.requirementsTagProviders == null) {
            this.requirementsTagProviders = this.loadRequirementsTagProviders();
        }
        return ImmutableList.copyOf(this.requirementsTagProviders);
    }

    private List<RequirementsTagProvider> loadRequirementsTagProviders() {
        ArrayList<RequirementsTagProvider> providers = new ArrayList<RequirementsTagProvider>();
        List<TagProvider> tagProviders = this.tagProviderService.getTagProviders();
        this.logger.info("Using requirements providers: {}", tagProviders);
        for (TagProvider tagProvider : tagProviders) {
            if (!(tagProvider instanceof RequirementsTagProvider)) continue;
            this.logger.info("ADDING REQUIREMENTS PROVIDER " + tagProvider);
            providers.add((RequirementsTagProvider)tagProvider);
        }
        this.removeDefaultProviderIfItIsNotFirstFrom(providers);
        return providers;
    }

    private void removeDefaultProviderIfItIsNotFirstFrom(List<RequirementsTagProvider> providers) {
        int defaultProviderPos = -1;
        for (int i = 0; i < providers.size(); ++i) {
            if (!(providers.get(i) instanceof FileSystemRequirementsTagProvider)) continue;
            defaultProviderPos = i;
            break;
        }
        if (defaultProviderPos > 0) {
            providers.remove(defaultProviderPos);
        }
    }
}

