/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.requirements.model.Example;

public class Requirement
implements Comparable {
    private final String displayName;
    private final String name;
    private final String type;
    private final String narrativeText;
    private final String cardNumber;
    private final List<Requirement> children;
    private final List<Example> examples;

    protected Requirement(String name, String displayName, String cardNumber, String type, String narrativeText, List<Requirement> children, List<Example> examples) {
        this.name = name;
        this.displayName = displayName;
        this.cardNumber = cardNumber;
        this.type = type;
        this.narrativeText = narrativeText;
        this.children = ImmutableList.copyOf(children);
        this.examples = ImmutableList.copyOf(examples);
    }

    protected Requirement(String name, String displayName, String cardNumber, String type, String narrativeText) {
        this.name = name;
        this.displayName = displayName;
        this.cardNumber = cardNumber;
        this.type = type;
        this.narrativeText = narrativeText;
        this.children = Collections.EMPTY_LIST;
        this.examples = Collections.EMPTY_LIST;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getType() {
        return this.type;
    }

    public String getChildType() {
        return !this.children.isEmpty() ? this.children.get(0).getType() : null;
    }

    public String getNarrativeText() {
        return this.narrativeText;
    }

    public int getChildrenCount() {
        return this.children.size();
    }

    public List<Requirement> getChildren() {
        return ImmutableList.copyOf(this.children);
    }

    public List<Example> getExamples() {
        return ImmutableList.copyOf(this.examples);
    }

    public Boolean hasExamples() {
        return !this.examples.isEmpty();
    }

    public int getExampleCount() {
        return this.examples.size();
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public int compareTo(Object otherRequirement) {
        return this.name.compareTo(((Requirement)otherRequirement).getName());
    }

    public static RequirementBuilderNameStep named(String name) {
        return new RequirementBuilderNameStep(name);
    }

    public Requirement withChildren(List<Requirement> children) {
        return new Requirement(this.name, this.displayName, this.cardNumber, this.type, this.narrativeText, children, this.examples);
    }

    public Requirement withExample(Example example) {
        ArrayList updatedExamples = Lists.newArrayList(this.examples);
        updatedExamples.add(example);
        return new Requirement(this.name, this.displayName, this.cardNumber, this.type, this.narrativeText, this.children, updatedExamples);
    }

    public Requirement withExamples(List<Example> examples) {
        return new Requirement(this.name, this.displayName, this.cardNumber, this.type, this.narrativeText, this.children, examples);
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public List<Requirement> getNestedChildren() {
        ArrayList nestedChildren = Lists.newArrayList();
        for (Requirement child : this.children) {
            nestedChildren.add(child);
            nestedChildren.addAll(child.getNestedChildren());
        }
        return ImmutableList.copyOf((Collection)nestedChildren);
    }

    public TestTag asTag() {
        return TestTag.withName(this.getName()).andType(this.getType());
    }

    public static class RequirementBuilderTypeStep {
        final RequirementBuilderNameStep requirementBuilderNameStep;
        final String type;

        public RequirementBuilderTypeStep(RequirementBuilderNameStep requirementBuilderNameStep, String type) {
            this.requirementBuilderNameStep = requirementBuilderNameStep;
            this.type = type;
        }

        public Requirement withNarrativeText(String narrativeText) {
            String name = this.requirementBuilderNameStep.name;
            String displayName = this.requirementBuilderNameStep.displayName;
            String cardNumber = this.requirementBuilderNameStep.cardNumber;
            return new Requirement(name, displayName, cardNumber, this.type, narrativeText);
        }
    }

    public static class RequirementBuilderNameStep {
        final String name;
        String displayName;
        String cardNumber;

        public RequirementBuilderNameStep(String name) {
            this.name = name;
            this.displayName = name;
        }

        public RequirementBuilderNameStep withOptionalDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public RequirementBuilderNameStep withOptionalCardNumber(String cardNumber) {
            this.cardNumber = cardNumber;
            return this;
        }

        public RequirementBuilderTypeStep withType(String type) {
            return new RequirementBuilderTypeStep(this, type);
        }
    }
}

