/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.util;

import java.util.Locale;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;

public final class NameConverter {
    private NameConverter() {
    }

    public static String humanize(String name) {
        if (name == null || name.trim().length() == 0) {
            return "";
        }
        if (name.contains(" ") && !NameConverter.thereAreParametersIn(name)) {
            return name;
        }
        if (NameConverter.thereAreParametersIn(name)) {
            return NameConverter.humanizeNameWithParameters(name);
        }
        String noUnderscores = name.replaceAll("_", " ");
        String splitCamelCase = NameConverter.splitCamelCase(noUnderscores);
        return StringUtils.capitalize((String)splitCamelCase);
    }

    private static String humanizeNameWithParameters(String name) {
        int parametersStartAt = name.indexOf(": ");
        String bareName = name.substring(0, parametersStartAt);
        String humanizedBareName = NameConverter.humanize(bareName);
        String parameters = name.substring(parametersStartAt);
        return humanizedBareName + parameters;
    }

    private static boolean thereAreParametersIn(String name) {
        return name.contains(": ");
    }

    public static String splitCamelCase(String name) {
        StringBuffer splitWords = new StringBuffer();
        boolean inWord = false;
        String currentWord = "";
        for (int index = 0; index < name.length(); ++index) {
            if (NameConverter.onWordBoundary(name, index)) {
                splitWords.append(NameConverter.lowercaseOrAcronym(currentWord)).append(" ");
                currentWord = String.valueOf(name.charAt(index));
                continue;
            }
            currentWord = currentWord + name.charAt(index);
        }
        splitWords.append(NameConverter.lowercaseOrAcronym(currentWord));
        return splitWords.toString().trim();
    }

    private static String lowercaseOrAcronym(String word) {
        if (StringUtils.isAllUpperCase((CharSequence)word) && word.length() > 1) {
            return word;
        }
        return StringUtils.lowerCase((String)word);
    }

    private static boolean onWordBoundary(String name, int index) {
        return NameConverter.uppercaseLetterAt(name, index) && (NameConverter.lowercaseLetterAt(name, index - 1) || NameConverter.lowercaseLetterAt(name, index + 1));
    }

    private static boolean uppercaseLetterAt(String name, int index) {
        return CharUtils.isAsciiAlphaUpper((char)name.charAt(index));
    }

    private static boolean lowercaseLetterAt(String name, int index) {
        return index >= 0 && index < name.length() && CharUtils.isAsciiAlphaLower((char)name.charAt(index));
    }

    public static String withNoArguments(String methodName) {
        return NameConverter.stripArgumentsFrom(NameConverter.stripIndexesFrom(methodName));
    }

    public static String withNoIssueNumbers(String methodName) {
        if (methodName == null) {
            return null;
        }
        int firstIssueNumberIndex = methodName.indexOf("_(#");
        if (firstIssueNumberIndex == -1) {
            firstIssueNumberIndex = methodName.indexOf("(#");
        }
        if (firstIssueNumberIndex == -1) {
            firstIssueNumberIndex = methodName.indexOf("#");
        }
        if (firstIssueNumberIndex > 0) {
            return methodName.substring(0, firstIssueNumberIndex);
        }
        return methodName;
    }

    public static String stripArgumentsFrom(String methodName) {
        if (methodName == null) {
            return null;
        }
        int firstArgument = methodName.indexOf(58);
        if (firstArgument > 0) {
            return methodName.substring(0, firstArgument);
        }
        return methodName;
    }

    public static String stripIndexesFrom(String methodName) {
        if (methodName == null) {
            return null;
        }
        int firstBracket = methodName.indexOf(91);
        if (firstBracket > 0) {
            return methodName.substring(0, firstBracket);
        }
        return methodName;
    }

    public static String underscore(String name) {
        if (name != null) {
            return name.replaceAll(" ", "_").replaceAll("<", "_").replaceAll(">", "_").replaceAll("'", "_").replaceAll(",", "_").replaceAll(":", "_").replaceAll("/", "_").replaceAll("\"", "_").replaceAll("=", "_").toLowerCase(Locale.getDefault()).trim();
        }
        return "";
    }
}

