/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.Inflector;
import org.apache.commons.lang3.StringUtils;

public class AbstractRequirementsTagProvider {
    public static final List<String> DEFAULT_CAPABILITY_TYPES = ImmutableList.of((Object)"capability", (Object)"feature");
    protected static final String DEFAULT_ROOT_DIRECTORY = "stories";
    protected final EnvironmentVariables environmentVariables;
    protected final String rootDirectory;

    protected AbstractRequirementsTagProvider(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.rootDirectory = this.getDefaultRootDirectory();
    }

    protected String humanReadableVersionOf(String name) {
        String underscoredName = Inflector.getInstance().underscore(name, new char[0]);
        return Inflector.getInstance().humanize(underscoredName, new String[0]);
    }

    protected String getDefaultType(int level) {
        List<String> types = this.getRequirementTypes();
        if (level > types.size() - 1) {
            return types.get(types.size() - 1);
        }
        return types.get(level);
    }

    protected List<String> getRequirementTypes() {
        String requirementTypes = ThucydidesSystemProperty.REQUIREMENT_TYPES.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)requirementTypes)) {
            Iterator types = Splitter.on((String)",").trimResults().split((CharSequence)requirementTypes).iterator();
            return Lists.newArrayList(types);
        }
        return DEFAULT_CAPABILITY_TYPES;
    }

    protected String getDefaultRootDirectory() {
        if (ThucydidesSystemProperty.ANNOTATED_REQUIREMENTS_DIRECTORY.isDefinedIn(this.environmentVariables)) {
            return ThucydidesSystemProperty.ANNOTATED_REQUIREMENTS_DIRECTORY.from(this.environmentVariables);
        }
        return DEFAULT_ROOT_DIRECTORY;
    }
}

