/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports;

import net.thucydides.core.model.NumericalFormatter;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.requirements.reports.RequirementsProportionCounter;

public class RequirementsPercentageFormatter {
    private final RequirementsProportionCounter counter;
    private final NumericalFormatter formatter;

    public RequirementsPercentageFormatter(RequirementsProportionCounter counter) {
        this.counter = counter;
        this.formatter = new NumericalFormatter();
    }

    public String withResult(String expectedResult) {
        double result = this.counter.withResult(expectedResult);
        return this.formatter.percentage(result, 1);
    }

    public String withResult(TestResult expectedResult) {
        double result = this.counter.withResult(expectedResult);
        return this.formatter.percentage(result, 1);
    }

    public String withIndeterminateResult() {
        double result = this.counter.withIndeterminateResult();
        return this.formatter.percentage(result, 1);
    }
}

