/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.guice;

import com.google.inject.Inject;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.DatabaseConfig;
import net.thucydides.core.statistics.database.LocalDatabase;
import net.thucydides.core.util.EnvironmentVariables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentVariablesDatabaseConfig
implements DatabaseConfig {
    private static final int TABLE_NAME_COLUMN = 3;
    private final EnvironmentVariables environmentVariables;
    private final LocalDatabase localDatabase;
    private boolean isActive = true;

    @Inject
    public EnvironmentVariablesDatabaseConfig(EnvironmentVariables environmentVariables, LocalDatabase localDatabase) {
        this.environmentVariables = environmentVariables;
        this.localDatabase = localDatabase;
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties();
        String driver = ThucydidesSystemProperty.STATISTICS_DRIVER.from(this.environmentVariables, this.localDatabase.getDriver());
        String url = ThucydidesSystemProperty.STATISTICS_URL.from(this.environmentVariables, this.localDatabase.getUrl());
        String username = ThucydidesSystemProperty.STATISTICS_USERNAME.from(this.environmentVariables, this.localDatabase.getUsername());
        String password = ThucydidesSystemProperty.STATISTICS_PASSWORD.from(this.environmentVariables, this.localDatabase.getPassword());
        String dialect = ThucydidesSystemProperty.STATISTICS_DIALECT.from(this.environmentVariables, this.localDatabase.getDialect());
        properties.put("hibernate.connection.driver_class", driver);
        properties.put("hibernate.connection.url", url);
        properties.put("hibernate.connection.username", username);
        properties.put("hibernate.connection.password", password);
        properties.put("hibernate.dialect", dialect);
        properties.put("hibernate.connection.pool_size", "1");
        boolean databaseIsConfigured = this.databaseIsConfigured(properties);
        if (this.isUsingLocalDatabase() || !databaseIsConfigured) {
            properties.put("hibernate.hbm2ddl.auto", "update");
        } else {
            properties.put("hibernate.hbm2ddl.auto", "validate");
        }
        return properties;
    }

    private boolean databaseIsConfigured(Properties targetConfiguration) {
        Properties connectionProps = new Properties();
        connectionProps.put("user", targetConfiguration.getProperty("hibernate.connection.username"));
        connectionProps.put("password", targetConfiguration.getProperty("hibernate.connection.password"));
        String jdbcConnection = targetConfiguration.getProperty("hibernate.connection.url");
        try {
            Connection conn = DriverManager.getConnection(jdbcConnection, connectionProps);
            List<String> tables = this.getTablesFrom(conn);
            return tables.contains("TESTRUN");
        }
        catch (SQLException e) {
            return false;
        }
    }

    private List<String> getTablesFrom(Connection conn) throws SQLException {
        DatabaseMetaData md = conn.getMetaData();
        ResultSet rs = md.getTables(null, null, "%", null);
        ArrayList<String> tableNames = new ArrayList<String>();
        while (rs.next()) {
            tableNames.add(rs.getString(3));
        }
        return tableNames;
    }

    @Override
    public boolean isUsingLocalDatabase() {
        return this.environmentVariables.getProperty("thucydides.statistics.url") == null;
    }

    private boolean isStatisticsDisabled() {
        return Boolean.valueOf(this.environmentVariables.getProperty(ThucydidesSystemProperty.RECORD_STATISTICS, "true")) == false;
    }

    @Override
    public void disable() {
        this.isActive = false;
    }

    @Override
    public void enable() {
        this.isActive = true;
    }

    @Override
    public boolean isActive() {
        return this.isActive && !this.isStatisticsDisabled();
    }
}

