/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.history;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.StreamException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.history.DateProvider;
import net.thucydides.core.reports.history.ProgressSnapshot;
import net.thucydides.core.reports.history.SystemDateProvider;
import net.thucydides.core.reports.history.TestResultSnapshot;
import net.thucydides.core.requirements.reports.RequirementsOutcomes;
import net.thucydides.core.util.EnvironmentVariables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestHistory {
    private static final String BUILD_ID = "BUILD_ID";
    private final File dataDirectory;
    private final String projectName;
    private final DateProvider dateProvider;
    protected EnvironmentVariables environmentVariables;

    public TestHistory(String projectName) {
        this(projectName, (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class), null);
    }

    public TestHistory(String projectName, File baseDirectory, DateProvider dateProvider) {
        this(projectName, (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class), baseDirectory, dateProvider);
    }

    public TestHistory(String projectName, EnvironmentVariables environmentVariables) {
        this(projectName, environmentVariables, null);
    }

    public TestHistory(String projectName, EnvironmentVariables environmentVariables, File baseDirectory) {
        this(projectName, environmentVariables, baseDirectory, new SystemDateProvider());
    }

    private TestHistory(String projectName, EnvironmentVariables environmentVariables, File baseDirectory, DateProvider dateProvider) {
        this.environmentVariables = environmentVariables;
        this.projectName = projectName;
        this.dataDirectory = baseDirectory != null ? baseDirectory : new File(this.getBaseDirectoryPath());
        this.dateProvider = dateProvider;
    }

    private String getBaseDirectoryPath() {
        String defaultBaseDirectory = new File(this.homeDirectory(), ".thucydides").getAbsolutePath();
        return this.environmentVariables.getProperty(ThucydidesSystemProperty.HISTORY_BASE_DIRECTORY.getPropertyName(), defaultBaseDirectory);
    }

    private String homeDirectory() {
        return this.environmentVariables.getProperty("user.home");
    }

    public void updateData(RequirementsOutcomes requirementsOutcome) {
        this.updateData(requirementsOutcome.getTestOutcomes());
        this.updateProgressHistory(requirementsOutcome);
    }

    public void updateData(TestOutcomes testOutcomes) {
        int totalStepCount = testOutcomes.getStepCount();
        int passingSteps = testOutcomes.getPassingTests().getStepCount();
        int failingSteps = testOutcomes.getFailingTests().getStepCount();
        int skippedSteps = totalStepCount - passingSteps - failingSteps;
        String buildId = this.getEnvironmentVariables().getValue(BUILD_ID, "MANUAL");
        TestResultSnapshot newSnapshot = new TestResultSnapshot(totalStepCount, passingSteps, failingSteps, skippedSteps, buildId);
        try {
            this.save(newSnapshot);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Unable to store history data", e);
        }
    }

    public void updateProgressHistory(RequirementsOutcomes requirementsOutcome) {
        String requirementType = requirementsOutcome.getType();
        int totalRequirements = requirementsOutcome.getRequirementCount();
        int completedRequirements = requirementsOutcome.getCompletedRequirementsCount();
        int failingRequirements = requirementsOutcome.getFailingRequirementsCount();
        String buildId = this.getEnvironmentVariables().getValue(BUILD_ID, "MANUAL");
        ProgressSnapshot newSnapshot = ProgressSnapshot.forRequirementType(requirementType).atTime(this.dateProvider.getCurrentTime()).with(completedRequirements).completed().and(failingRequirements).failed().outOf(totalRequirements).forBuild(buildId);
        try {
            this.save(newSnapshot);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Unable to store history data", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(TestResultSnapshot snapshot) throws FileNotFoundException {
        XStream xstream = new XStream();
        File snapshotFile = new File(this.getDirectory(), this.outcomesPrefix() + snapshot.getTime().getMillis());
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(snapshotFile);
            xstream.toXML((Object)snapshot, (OutputStream)out);
        }
        finally {
            this.close(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(ProgressSnapshot snapshot) throws FileNotFoundException {
        XStream xstream = new XStream();
        File snapshotFile = new File(this.getDirectory(), this.progressPrefix() + snapshot.getTime().getMillis());
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(snapshotFile);
            xstream.toXML((Object)snapshot, (OutputStream)out);
        }
        finally {
            this.close(out);
        }
    }

    private void close(Closeable stream) {
        try {
            stream.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to close history file", e);
        }
    }

    public File getDirectory() {
        File projectDirectory = new File(this.dataDirectory, this.projectName);
        if (!projectDirectory.exists()) {
            projectDirectory.mkdirs();
        }
        return projectDirectory;
    }

    public List<TestResultSnapshot> getHistory() {
        File[] historyFiles = this.getOutcomeFiles();
        ArrayList<TestResultSnapshot> resultSnapshots = new ArrayList<TestResultSnapshot>();
        XStream xstream = new XStream();
        for (File historyFile : historyFiles) {
            TestResultSnapshot snapshot = null;
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(historyFile);
                snapshot = (TestResultSnapshot)xstream.fromXML((InputStream)inputStream);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("Unable to read history data in " + historyFile, e);
            }
            catch (StreamException streamException) {
                throw new IllegalArgumentException("Unable to parse history data in " + historyFile, streamException);
            }
            finally {
                this.close(inputStream);
            }
            resultSnapshots.add(snapshot);
        }
        Collections.sort(resultSnapshots);
        return resultSnapshots;
    }

    public List<ProgressSnapshot> getProgress() {
        File[] historyFiles = this.getProgressFiles();
        ArrayList<ProgressSnapshot> resultSnapshots = new ArrayList<ProgressSnapshot>();
        XStream xstream = new XStream();
        for (File historyFile : historyFiles) {
            ProgressSnapshot snapshot = null;
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(historyFile);
                snapshot = (ProgressSnapshot)xstream.fromXML((InputStream)inputStream);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("Unable to read history data in " + historyFile, e);
            }
            catch (StreamException streamException) {
                throw new IllegalArgumentException("Unable to parse history data in " + historyFile, streamException);
            }
            finally {
                this.close(inputStream);
            }
            resultSnapshots.add(snapshot);
        }
        Collections.sort(resultSnapshots);
        return resultSnapshots;
    }

    private File[] getOutcomeFiles() {
        return this.getDirectory().listFiles(new FilenameFilter(){

            public boolean accept(File directory, String filename) {
                return filename.startsWith(TestHistory.this.outcomesPrefix());
            }
        });
    }

    private File[] getProgressFiles() {
        return this.getDirectory().listFiles(new FilenameFilter(){

            public boolean accept(File directory, String filename) {
                return filename.startsWith(TestHistory.this.progressPrefix());
            }
        });
    }

    private File[] getHistoryFiles() {
        return this.getDirectory().listFiles(new FilenameFilter(){

            public boolean accept(File directory, String filename) {
                return filename.startsWith(TestHistory.this.outcomesPrefix()) || filename.startsWith(TestHistory.this.progressPrefix());
            }
        });
    }

    private String outcomesPrefix() {
        return "thucydides-outcome-";
    }

    private String progressPrefix() {
        return "thucydides-progress-";
    }

    public void clearHistory() {
        File[] historyFiles;
        for (File historyFile : historyFiles = this.getHistoryFiles()) {
            historyFile.delete();
        }
    }

    protected EnvironmentVariables getEnvironmentVariables() {
        return this.environmentVariables;
    }
}

