/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.thucydides.core.model.TestTag;

public class Release
implements Comparable {
    private final TestTag releaseTag;
    private final List<Release> children;
    private final String label;
    private final String reportName;
    private final List<Release> parents;

    public static Release ofVersion(String versionName) {
        return new Release(TestTag.withName(versionName).andType("version"));
    }

    public Release(TestTag releaseTag) {
        this.releaseTag = releaseTag;
        this.label = releaseTag.getName();
        this.children = ImmutableList.of();
        this.parents = ImmutableList.of();
        this.reportName = null;
    }

    public Release(TestTag releaseTag, List<Release> children, List<Release> parents, String reportName) {
        this.releaseTag = releaseTag;
        this.label = releaseTag.getName();
        this.children = ImmutableList.copyOf(children);
        this.parents = ImmutableList.copyOf(parents);
        this.reportName = reportName;
    }

    public Release withChildren(List<Release> children) {
        return new Release(this.releaseTag, children, this.parents, this.reportName);
    }

    public Release withParents(List<Release> parents) {
        return new Release(this.releaseTag, this.children, parents, this.reportName);
    }

    public Release withReport(String reportName) {
        return new Release(this.releaseTag, this.children, this.parents, reportName);
    }

    public String getName() {
        return this.releaseTag.getName();
    }

    public String getLabel() {
        return this.label;
    }

    public List<Release> getChildren() {
        return this.children;
    }

    public List<Release> getParents() {
        return this.parents;
    }

    public TestTag getReleaseTag() {
        return this.releaseTag;
    }

    public String getReportName() {
        return this.reportName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Release release = (Release)o;
        return this.releaseTag.equals(release.releaseTag);
    }

    public int hashCode() {
        return this.releaseTag.hashCode();
    }

    public int compareTo(Object otherRelease) {
        return this.getName().compareTo(((Release)otherRelease).getName());
    }
}

