/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.xml;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.AcceptanceTestLoader;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.xml.TestOutcomeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLTestOutcomeReporter
implements AcceptanceTestReporter,
AcceptanceTestLoader {
    private File outputDirectory;
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLTestOutcomeReporter.class);
    private transient String qualifier;

    @Override
    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    @Override
    public void setResourceDirectory(String resourceDirectoryPath) {
    }

    @Override
    public String getName() {
        return "xml";
    }

    @Override
    public File generateReportFor(TestOutcome testOutcome, TestOutcomes allTestOutcomes) throws IOException {
        TestOutcome storedTestOutcome = testOutcome.withQualifier(this.qualifier);
        Preconditions.checkNotNull((Object)this.outputDirectory);
        XStream xstream = new XStream();
        xstream.alias("acceptance-test-run", TestOutcome.class);
        xstream.registerConverter((Converter)this.usingXmlConverter());
        String reportFilename = this.reportFor(storedTestOutcome);
        FileOutputStream outputStream = null;
        OutputStreamWriter writer = null;
        File report = new File(this.getOutputDirectory(), reportFilename);
        try {
            outputStream = new FileOutputStream(report);
            writer = new OutputStreamWriter((OutputStream)outputStream, Charset.forName("UTF-8"));
            xstream.toXML((Object)storedTestOutcome, (Writer)writer);
        }
        catch (IOException failedToWriteReport) {
            throw failedToWriteReport;
        }
        finally {
            writer.flush();
            writer.close();
            ((OutputStream)outputStream).close();
        }
        return report;
    }

    private TestOutcomeConverter usingXmlConverter() {
        return new TestOutcomeConverter();
    }

    private String reportFor(TestOutcome testOutcome) {
        return testOutcome.withQualifier(this.qualifier).getReportName(ReportType.XML);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<TestOutcome> loadReportFrom(File reportFile) throws IOException {
        InputStream input = null;
        InputStreamReader reader = null;
        try {
            XStream xstream = new XStream();
            xstream.alias("acceptance-test-run", TestOutcome.class);
            xstream.registerConverter((Converter)this.usingXmlConverter());
            input = new FileInputStream(reportFile);
            reader = new InputStreamReader(input, Charset.forName("UTF-8"));
            Optional optional = Optional.of((Object)((TestOutcome)xstream.fromXML((Reader)reader)));
            return optional;
        }
        catch (CannotResolveClassException e) {
            LOGGER.warn("Tried to load a file that is not a thucydides report: " + reportFile);
            Optional optional = Optional.absent();
            return optional;
        }
        finally {
            reader.close();
            input.close();
        }
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    public List<TestOutcome> loadReportsFrom(File outputDirectory) throws IOException {
        File[] reportFiles = this.getAllXMLFilesFrom(outputDirectory);
        ArrayList testOutcomes = Lists.newArrayList();
        if (reportFiles != null) {
            for (File reportFile : reportFiles) {
                testOutcomes.addAll(this.loadReportFrom(reportFile).asSet());
            }
        }
        return testOutcomes;
    }

    private File[] getAllXMLFilesFrom(File reportsDirectory) {
        return reportsDirectory.listFiles(new XmlFilenameFilter());
    }

    private static final class XmlFilenameFilter
    implements FilenameFilter {
        private XmlFilenameFilter() {
        }

        @Override
        public boolean accept(File file, String filename) {
            return filename.toLowerCase(Locale.getDefault()).endsWith(".xml");
        }
    }
}

