/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class RequirementsConfiguration {
    public static final List<String> DEFAULT_CAPABILITY_TYPES = ImmutableList.of((Object)"capability", (Object)"feature");
    protected static final String DEFAULT_ROOT_DIRECTORY = "stories";
    private EnvironmentVariables environmentVariables;

    public RequirementsConfiguration(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public List<String> getRequirementTypes() {
        String requirementTypes = ThucydidesSystemProperty.REQUIREMENT_TYPES.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)requirementTypes)) {
            Iterator types = Splitter.on((String)",").trimResults().split((CharSequence)requirementTypes).iterator();
            return Lists.newArrayList(types);
        }
        return DEFAULT_CAPABILITY_TYPES;
    }

    public String getDefaultRootDirectory() {
        if (ThucydidesSystemProperty.ANNOTATED_REQUIREMENTS_DIRECTORY.isDefinedIn(this.environmentVariables)) {
            return ThucydidesSystemProperty.ANNOTATED_REQUIREMENTS_DIRECTORY.from(this.environmentVariables);
        }
        return DEFAULT_ROOT_DIRECTORY;
    }
}

