/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thucydides.core.ThucydidesSystemProperties;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.NumericalFormatter;
import net.thucydides.core.model.Release;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.releases.ReleaseManager;
import net.thucydides.core.reports.ReportOptions;
import net.thucydides.core.reports.TestOutcomeLoader;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.UserStoryTestReporter;
import net.thucydides.core.reports.csv.CSVReporter;
import net.thucydides.core.reports.history.TestHistory;
import net.thucydides.core.reports.history.TestResultSnapshot;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.reports.html.HtmlProgressReporter;
import net.thucydides.core.reports.html.HtmlReporter;
import net.thucydides.core.reports.html.HtmlRequirementsReporter;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.reports.html.ReportProperties;
import net.thucydides.core.reports.html.TagFilter;
import net.thucydides.core.requirements.RequirementsProviderService;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.model.RequirementsConfiguration;
import net.thucydides.core.requirements.reports.RequirementOutcome;
import net.thucydides.core.requirements.reports.RequirementsOutcomes;
import net.thucydides.core.requirements.reports.RequirmentsOutcomeFactory;
import net.thucydides.core.util.Inflector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlAggregateStoryReporter
extends HtmlReporter
implements UserStoryTestReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlAggregateStoryReporter.class);
    private static final String HISTORY_TEMPLATE_PATH = "freemarker/history.ftl";
    private static final String TEST_OUTCOME_TEMPLATE_PATH = "freemarker/home.ftl";
    private static final String RELEASES_TEMPLATE_PATH = "freemarker/releases.ftl";
    private static final String RELEASE_TEMPLATE_PATH = "freemarker/release.ftl";
    private static final String TAGTYPE_TEMPLATE_PATH = "freemarker/results-by-tagtype.ftl";
    private TestHistory testHistory;
    private String projectName;
    private String relativeLink;
    private ReportNameProvider reportNameProvider;
    private final IssueTracking issueTracking;
    private final RequirmentsOutcomeFactory requirementsFactory;
    private final HtmlRequirementsReporter htmlRequirementsReporter;
    private final HtmlProgressReporter htmlProgressReporter;
    private final RequirementsConfiguration requirementsConfiguration;
    private ReleaseManager releaseManager;
    private ReportNameProvider defaultNameProvider;

    public HtmlAggregateStoryReporter(String projectName) {
        this(projectName, "");
    }

    public HtmlAggregateStoryReporter(String projectName, String relativeLink) {
        this(projectName, relativeLink, (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class), new TestHistory(projectName));
    }

    public HtmlAggregateStoryReporter(String projectName, IssueTracking issueTracking, TestHistory testHistory) {
        this(projectName, "", issueTracking, testHistory);
    }

    public HtmlAggregateStoryReporter(String projectName, String relativeLink, IssueTracking issueTracking, TestHistory testHistory) {
        this.projectName = projectName;
        this.relativeLink = relativeLink;
        this.issueTracking = issueTracking;
        this.testHistory = testHistory;
        this.reportNameProvider = new ReportNameProvider();
        this.htmlRequirementsReporter = new HtmlRequirementsReporter(relativeLink);
        this.htmlProgressReporter = new HtmlProgressReporter(issueTracking, testHistory);
        RequirementsProviderService requirementsProviderService = (RequirementsProviderService)Injectors.getInjector().getInstance(RequirementsProviderService.class);
        this.requirementsFactory = new RequirmentsOutcomeFactory(requirementsProviderService.getRequirementsProviders(), issueTracking);
        this.requirementsConfiguration = new RequirementsConfiguration(this.getEnvironmentVariables());
    }

    public String getProjectName() {
        return this.projectName;
    }

    protected TestHistory getTestHistory() {
        if (this.testHistory == null) {
            this.testHistory = new TestHistory(this.getProjectName());
        }
        return this.testHistory;
    }

    private void addFormattersToContext(Map<String, Object> context) {
        Formatter formatter = new Formatter(this.issueTracking);
        context.put("formatter", formatter);
        context.put("formatted", new NumericalFormatter());
        context.put("inflection", Inflector.getInstance());
        context.put("relativeLink", this.relativeLink);
    }

    @Override
    public TestOutcomes generateReportsForTestResultsFrom(File sourceDirectory) throws IOException {
        TestOutcomes allTestOutcomes = this.loadTestOutcomesFrom(sourceDirectory);
        this.generateReportsForTestResultsIn(allTestOutcomes);
        return allTestOutcomes;
    }

    public void generateReportsForTestResultsIn(TestOutcomes testOutcomes) throws IOException {
        RequirementsOutcomes requirementsOutcomes = this.requirementsFactory.buildRequirementsOutcomesFrom(testOutcomes);
        this.updateHistoryFor(requirementsOutcomes);
        this.copyResourcesToOutputDirectory();
        this.copyTestResultsToOutputDirectory();
        this.generateAggregateReportFor(testOutcomes);
        this.generateTagReportsFor(testOutcomes);
        this.generateTagTypeReportsFor(testOutcomes);
        for (String name : testOutcomes.getTagNames()) {
            this.generateTagTypeReportsFor(testOutcomes.withTag(name), new ReportNameProvider(name));
        }
        List<String> requirementTypes = requirementsOutcomes.getTypes();
        for (String requirementType : requirementTypes) {
            this.generateRequirementTypeReportFor(requirementType, requirementsOutcomes.requirementsOfType(requirementType).getTestOutcomes());
        }
        this.generateResultReportsFor(testOutcomes);
        this.generateHistoryReportFor(testOutcomes);
        this.generateRequirementsReportsFor(requirementsOutcomes);
        this.generateReleasesReportFor(testOutcomes, requirementsOutcomes);
    }

    private void generateRequirementTypeReportFor(String requirementType, TestOutcomes testOutcomes) {
    }

    private void generateCSVReportFor(TestOutcomes testOutcomes, String reportName) throws IOException {
        CSVReporter csvReporter = new CSVReporter(this.getOutputDirectory(), this.getEnvironmentVariables());
        csvReporter.generateReportFor(testOutcomes, reportName);
    }

    public void generateRequirementsReportsFor(RequirementsOutcomes requirementsOutcomes) throws IOException {
        this.htmlRequirementsReporter.setOutputDirectory(this.getOutputDirectory());
        this.htmlRequirementsReporter.generateReportFor(requirementsOutcomes);
        this.htmlProgressReporter.setOutputDirectory(this.getOutputDirectory());
        this.htmlProgressReporter.generateReportFor(requirementsOutcomes);
        this.generateRequirementsReportsForChildRequirements(requirementsOutcomes);
    }

    private void generateRequirementsReportsForChildRequirements(RequirementsOutcomes requirementsOutcomes) throws IOException {
        List<RequirementOutcome> requirementOutcomes = requirementsOutcomes.getRequirementOutcomes();
        for (RequirementOutcome outcome : requirementOutcomes) {
            Requirement requirement = outcome.getRequirement();
            TestOutcomes testOutcomesForThisRequirement = outcome.getTestOutcomes().withTag(requirement.getName());
            RequirementsOutcomes requirementOutcomesForThisRequirement = this.requirementsFactory.buildRequirementsOutcomesFrom(requirement, testOutcomesForThisRequirement);
            this.generateNestedRequirementsReportsFor(requirement, requirementOutcomesForThisRequirement);
        }
    }

    private void generateNestedRequirementsReportsFor(Requirement parentRequirement, RequirementsOutcomes requirementsOutcomes) throws IOException {
        this.htmlRequirementsReporter.setOutputDirectory(this.getOutputDirectory());
        String reportName = this.reportNameProvider.forRequirement(parentRequirement);
        this.htmlRequirementsReporter.generateReportFor(requirementsOutcomes, requirementsOutcomes.getTestOutcomes(), reportName);
        this.generateRequirementsReportsForChildRequirements(requirementsOutcomes);
    }

    private TestOutcomes loadTestOutcomesFrom(File sourceDirectory) throws IOException {
        return TestOutcomeLoader.testOutcomesIn(sourceDirectory).withHistory();
    }

    private void generateAggregateReportFor(TestOutcomes testOutcomes) throws IOException {
        ReportNameProvider defaultNameProvider = new ReportNameProvider();
        Map<String, Object> context = this.buildContext(testOutcomes, defaultNameProvider);
        context.put("report", ReportProperties.forAggregateResultsReport());
        context.put("csvReport", "results.csv");
        this.generateReportPage(context, TEST_OUTCOME_TEMPLATE_PATH, "index.html");
        this.generateCSVReportFor(testOutcomes, "results.csv");
    }

    private ReleaseManager getReleaseManager() {
        if (this.releaseManager == null) {
            ReportNameProvider defaultNameProvider = new ReportNameProvider();
            this.releaseManager = new ReleaseManager(this.getEnvironmentVariables(), defaultNameProvider);
        }
        return this.releaseManager;
    }

    private ReportNameProvider getReportNameProvider() {
        if (this.defaultNameProvider == null) {
            this.defaultNameProvider = new ReportNameProvider();
        }
        return this.defaultNameProvider;
    }

    private void generateReleasesReportFor(TestOutcomes testOutcomes, RequirementsOutcomes requirementsOutcomes) throws IOException {
        Map<String, Object> context = this.buildContext(testOutcomes, this.getReportNameProvider());
        context.put("report", ReportProperties.forAggregateResultsReport());
        List<Release> releases = this.getReleaseManager().getReleasesFrom(testOutcomes);
        String releaseData = this.getReleaseManager().getJSONReleasesFrom(testOutcomes);
        context.put("releases", releases);
        context.put("releaseData", releaseData);
        context.put("requirements", requirementsOutcomes);
        context.put("releaseRequirementOutcomes", requirementsOutcomes.getRequirementOutcomes());
        this.generateReportPage(context, RELEASES_TEMPLATE_PATH, "releases.html");
        this.generateReleaseDetailsReportsFor(testOutcomes, requirementsOutcomes);
    }

    private void generateReleaseDetailsReportsFor(TestOutcomes testOutcomes, RequirementsOutcomes requirementsOutcomes) throws IOException {
        List<Release> allReleases = this.getReleaseManager().getFlattenedReleasesFrom(testOutcomes);
        String topLevelRequirementType = this.requirementsConfiguration.getRequirementTypes().get(0);
        String secondLevelRequirementType = this.requirementsConfiguration.getRequirementTypes().get(1);
        String topLevelRequirementTypeTitle = Inflector.getInstance().of(topLevelRequirementType).inPluralForm().asATitle().toString();
        String secondLevelRequirementTypeTitle = Inflector.getInstance().of(secondLevelRequirementType).inPluralForm().asATitle().toString();
        for (Release release : allReleases) {
            RequirementsOutcomes releaseRequirements = requirementsOutcomes.getReleasedRequirementsFor(release);
            Map<String, Object> context = this.buildContext(testOutcomes, this.getReportNameProvider());
            requirementsOutcomes.getRequirementOutcomes().get(0).count("AUTOMATED").withIndeterminateResult();
            context.put("report", ReportProperties.forAggregateResultsReport());
            context.put("release", release);
            context.put("releaseData", this.getReleaseManager().getJSONReleasesFrom(release));
            context.put("requirementOutcomes", releaseRequirements);
            context.put("requirements", requirementsOutcomes);
            context.put("releaseRequirementOutcomes", requirementsOutcomes.getRequirementOutcomes());
            context.put("requirementType", topLevelRequirementTypeTitle);
            context.put("secondLevelRequirementType", secondLevelRequirementTypeTitle);
            String reportName = this.getReportNameProvider().forRelease(release);
            this.generateReportPage(context, RELEASE_TEMPLATE_PATH, reportName);
        }
    }

    private void generateTagReportsFor(TestOutcomes testOutcomes) throws IOException {
        for (TestTag tag : testOutcomes.getTags()) {
            this.generateTagReport(testOutcomes, this.reportNameProvider, tag);
            this.generateAssociatedTagReportsForTag(testOutcomes.withTag(tag.getName()), tag.getName());
        }
    }

    private void generateTagTypeReportsFor(TestOutcomes testOutcomes) throws IOException {
        this.generateTagTypeReportsFor(testOutcomes, this.reportNameProvider);
    }

    private void generateTagTypeReportsFor(TestOutcomes testOutcomes, ReportNameProvider reportNameProvider) throws IOException {
        for (String tagType : testOutcomes.getTagTypes()) {
            this.generateTagTypeReport(testOutcomes, reportNameProvider, tagType);
        }
    }

    private void generateResultReportsFor(TestOutcomes testOutcomes) throws IOException {
        this.generateResultReports(testOutcomes, this.reportNameProvider, "");
        for (TestTag tag : testOutcomes.getTags()) {
            this.generateResultReports(testOutcomes.withTag(tag.getName()), new ReportNameProvider(tag.getName()), tag.getType());
        }
    }

    private void generateResultReports(TestOutcomes testOutcomesForThisTag, ReportNameProvider reportName, String tagType) throws IOException {
        if (testOutcomesForThisTag.getTotalTests().withResult(TestResult.SUCCESS) > 0) {
            this.generateResultReport(testOutcomesForThisTag.getPassingTests(), reportName, tagType, "success");
        }
        if (testOutcomesForThisTag.getTotalTests().withIndeterminateResult() > 0) {
            this.generateResultReport(testOutcomesForThisTag.getPendingTests(), reportName, tagType, "pending");
        }
        if (testOutcomesForThisTag.getTotalTests().withResult(TestResult.FAILURE) > 0) {
            this.generateResultReport(testOutcomesForThisTag.getFailingTests(), reportName, tagType, "failure");
        }
        if (testOutcomesForThisTag.getTotalTests().withResult(TestResult.ERROR) > 0) {
            this.generateResultReport(testOutcomesForThisTag.getErrorTests(), reportName, tagType, "error");
        }
    }

    private void generateResultReport(TestOutcomes testOutcomes, ReportNameProvider reportName, String tagType, String testResult) throws IOException {
        Map<String, Object> context = this.buildContext(testOutcomes, reportName);
        context.put("report", ReportProperties.forTestResultsReport());
        context.put("currentTagType", tagType);
        String csvReport = reportName.forCSVFiles().forTestResult(testResult);
        context.put("csvReport", csvReport);
        String report = reportName.forTestResult(testResult);
        this.generateReportPage(context, TEST_OUTCOME_TEMPLATE_PATH, report);
        this.generateCSVReportFor(testOutcomes, csvReport);
    }

    private void generateTagReport(TestOutcomes testOutcomes, ReportNameProvider reportName, TestTag tag) throws IOException {
        TestOutcomes testOutcomesForTag = testOutcomes.withTag(tag.getName());
        Map<String, Object> context = this.buildContext(testOutcomesForTag, reportName);
        context.put("report", ReportProperties.forTagResultsReport());
        context.put("currentTagType", tag.getType());
        String csvReport = reportName.forCSVFiles().forTag(tag.getName());
        context.put("csvReport", csvReport);
        String report = reportName.forTag(tag.getName());
        this.generateReportPage(context, TEST_OUTCOME_TEMPLATE_PATH, report);
        this.generateCSVReportFor(testOutcomesForTag, csvReport);
    }

    private void generateTagTypeReport(TestOutcomes testOutcomes, ReportNameProvider reportName, String tagType) throws IOException {
        TestOutcomes testOutcomesForTagType = testOutcomes.withTagType(tagType);
        Map<String, Object> context = this.buildContext(testOutcomesForTagType, reportName);
        context.put("report", ReportProperties.forTagTypeResultsReport());
        context.put("tagType", tagType);
        String csvReport = reportName.forCSVFiles().forTagType(tagType);
        context.put("csvReport", csvReport);
        String report = reportName.forTagType(tagType);
        this.generateReportPage(context, TAGTYPE_TEMPLATE_PATH, report);
        this.generateCSVReportFor(testOutcomesForTagType, csvReport);
    }

    private void generateAssociatedTagReportsForTag(TestOutcomes testOutcomes, String sourceTag) throws IOException {
        ReportNameProvider reportName = new ReportNameProvider(sourceTag);
        for (TestTag tag : testOutcomes.getTags()) {
            this.generateTagReport(testOutcomes, reportName, tag);
        }
    }

    private Map<String, Object> buildContext(TestOutcomes testOutcomesForTagType, ReportNameProvider reportName) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        TagFilter tagFilter = new TagFilter(this.getEnvironmentVariables());
        context.put("testOutcomes", testOutcomesForTagType);
        context.put("allTestOutcomes", testOutcomesForTagType.getRootOutcomes());
        context.put("tagTypes", tagFilter.filteredTagTypes(testOutcomesForTagType.getTagTypes()));
        context.put("reportName", reportName);
        context.put("reportOptions", new ReportOptions(this.getEnvironmentVariables()));
        context.put("timestamp", this.timestampFrom(testOutcomesForTagType.getRootOutcomes()));
        this.addFormattersToContext(context);
        return context;
    }

    private void updateHistoryFor(RequirementsOutcomes requirementsOutcomes) {
        this.getTestHistory().updateData(requirementsOutcomes);
    }

    private void generateHistoryReportFor(TestOutcomes testOutcomes) throws IOException {
        List<TestResultSnapshot> history = this.getTestHistory().getHistory();
        Map<String, Object> context = this.buildContext(testOutcomes, this.reportNameProvider);
        context.put("history", history);
        context.put("rowcount", history.size());
        this.addFormattersToContext(context);
        String htmlContents = this.mergeTemplate(HISTORY_TEMPLATE_PATH).usingContext(context);
        LOGGER.debug("Writing history page");
        this.writeReportToOutputDirectory("history.html", htmlContents);
    }

    private void generateReportPage(Map<String, Object> context, String template, String outputFile) throws IOException {
        String htmlContents = this.mergeTemplate(template).usingContext(context);
        this.writeReportToOutputDirectory(outputFile, htmlContents);
    }

    public void clearHistory() {
        this.getTestHistory().clearHistory();
    }

    protected ThucydidesSystemProperties getSystemProperties() {
        return ThucydidesSystemProperties.getProperties();
    }

    public void setIssueTrackerUrl(String issueTrackerUrl) {
        if (issueTrackerUrl != null) {
            this.getSystemProperties().setValue(ThucydidesSystemProperty.ISSUE_TRACKER_URL, issueTrackerUrl);
        }
    }

    public void setJiraUrl(String jiraUrl) {
        if (jiraUrl != null) {
            this.getSystemProperties().setValue(ThucydidesSystemProperty.JIRA_URL, jiraUrl);
        }
    }

    public void setJiraProject(String jiraProject) {
        if (jiraProject != null) {
            this.getSystemProperties().setValue(ThucydidesSystemProperty.JIRA_PROJECT, jiraProject);
        }
    }

    public void setJiraUsername(String jiraUsername) {
        if (jiraUsername != null) {
            this.getSystemProperties().setValue(ThucydidesSystemProperty.JIRA_USERNAME, jiraUsername);
        }
    }

    public void setJiraPassword(String jiraPassword) {
        if (jiraPassword != null) {
            this.getSystemProperties().setValue(ThucydidesSystemProperty.JIRA_PASSWORD, jiraPassword);
        }
    }
}

