/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import com.beust.jcommander.internal.Lists;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.Release;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.releases.ReleaseManager;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.requirements.AnnotationBasedTagProvider;
import net.thucydides.core.requirements.FileSystemRequirementsTagProvider;
import net.thucydides.core.requirements.RequirementsProviderService;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.requirements.RequirementsTagProvider;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.statistics.service.FeatureStoryTagProvider;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequirementsServiceImplementation
implements RequirementsService {
    private List<RequirementsTagProvider> requirementsTagProviders;
    private List<Requirement> requirements;
    private Map<Requirement, List<Requirement>> requirementAncestors;
    private final EnvironmentVariables environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementsTagProvider.class);
    private static final List<String> LOW_PRIORITY_PROVIDERS = ImmutableList.of((Object)AnnotationBasedTagProvider.class.getCanonicalName(), (Object)FeatureStoryTagProvider.class.getCanonicalName(), (Object)FileSystemRequirementsTagProvider.class.getCanonicalName());
    ReleaseManager releaseManager;

    @Override
    public List<Requirement> getRequirements() {
        if (this.requirements == null) {
            this.requirements = Lists.newArrayList();
            for (RequirementsTagProvider tagProvider : this.getRequirementsTagProviders()) {
                LOGGER.info("Reading requirements from " + tagProvider);
                this.requirements = tagProvider.getRequirements();
                if (this.requirements.isEmpty()) continue;
                break;
            }
            this.indexRequirements();
            LOGGER.info("Requirements found:" + this.requirements);
        }
        return this.requirements;
    }

    private void indexRequirements() {
        this.requirementAncestors = Maps.newHashMap();
        for (Requirement requirement : this.requirements) {
            ImmutableList requirementPath = ImmutableList.of((Object)requirement);
            this.requirementAncestors.put(requirement, (List<Requirement>)ImmutableList.of((Object)requirement));
            LOGGER.info("Requirement ancestors for:" + requirement + " = " + requirementPath);
            this.indexChildRequirements((List<Requirement>)requirementPath, requirement.getChildren());
        }
    }

    private ReleaseManager getReleaseManager() {
        if (this.releaseManager == null) {
            ReportNameProvider defaultNameProvider = new ReportNameProvider();
            this.releaseManager = new ReleaseManager(this.environmentVariables, defaultNameProvider);
        }
        return this.releaseManager;
    }

    private Map<Requirement, List<Requirement>> getRequirementAncestors() {
        if (this.requirementAncestors == null) {
            this.getRequirements();
        }
        return this.requirementAncestors;
    }

    private void indexChildRequirements(List<Requirement> ancestors, List<Requirement> children) {
        for (Requirement requirement : children) {
            List requirementPath = Lists.newArrayList(ancestors);
            requirementPath.add(requirement);
            this.requirementAncestors.put(requirement, (List<Requirement>)ImmutableList.copyOf((Collection)requirementPath));
            LOGGER.info("Requirement ancestors for:" + requirement + " = " + requirementPath);
            this.indexChildRequirements(requirementPath, requirement.getChildren());
        }
    }

    @Override
    public Optional<Requirement> getParentRequirementFor(TestOutcome testOutcome) {
        try {
            for (RequirementsTagProvider tagProvider : this.getRequirementsTagProviders()) {
                Optional<Requirement> requirement = tagProvider.getParentRequirementOf(testOutcome);
                if (!requirement.isPresent()) continue;
                return requirement;
            }
        }
        catch (RuntimeException handleTagProvidersElegantly) {
            LOGGER.error("Tag provider failure", (Throwable)handleTagProvidersElegantly);
        }
        return Optional.absent();
    }

    @Override
    public Optional<Requirement> getRequirementFor(TestTag tag) {
        try {
            for (RequirementsTagProvider tagProvider : this.getRequirementsTagProviders()) {
                Optional<Requirement> requirement = tagProvider.getRequirementFor(tag);
                if (!requirement.isPresent()) continue;
                return requirement;
            }
        }
        catch (RuntimeException handleTagProvidersElegantly) {
            LOGGER.error("Tag provider failure", (Throwable)handleTagProvidersElegantly);
        }
        return Optional.absent();
    }

    @Override
    public List<Requirement> getAncestorRequirementsFor(TestOutcome testOutcome) {
        for (RequirementsTagProvider tagProvider : this.getRequirementsTagProviders()) {
            Optional<Requirement> requirement = tagProvider.getParentRequirementOf(testOutcome);
            if (!requirement.isPresent()) continue;
            LOGGER.info("Requirement found for test outcome " + testOutcome.getTitle() + "-" + testOutcome.getIssueKeys() + ":");
            LOGGER.info("Requirement:" + requirement);
            if (this.getRequirementAncestors().containsKey(requirement.get())) {
                return this.getRequirementAncestors().get(requirement.get());
            }
            LOGGER.warn("Requirement without identified ancestors found:" + ((Requirement)requirement.get()).getCardNumber());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<String> getReleaseVersionsFor(TestOutcome testOutcome) {
        List releases = Lists.newArrayList(testOutcome.getVersions());
        for (Requirement parentRequirement : this.getAncestorRequirementsFor(testOutcome)) {
            releases.addAll(parentRequirement.getReleaseVersions());
        }
        return releases;
    }

    @Override
    public List<Release> getReleasesFromRequirements() {
        List<List<String>> releaseVersions = this.getReleaseVersionsFrom(this.getRequirements());
        return this.getReleaseManager().extractReleasesFrom(releaseVersions);
    }

    private List<List<String>> getReleaseVersionsFrom(List<Requirement> requirements) {
        List releaseVersions = Lists.newArrayList();
        for (Requirement requirement : requirements) {
            releaseVersions.add(requirement.getReleaseVersions());
            releaseVersions.addAll(this.getReleaseVersionsFrom(requirement.getChildren()));
        }
        return releaseVersions;
    }

    private List<RequirementsTagProvider> getRequirementsTagProviders() {
        if (this.requirementsTagProviders == null) {
            RequirementsProviderService requirementsProviderService = (RequirementsProviderService)Injectors.getInjector().getInstance(RequirementsProviderService.class);
            this.requirementsTagProviders = this.reprioritizeProviders(this.active(requirementsProviderService.getRequirementsProviders()));
        }
        return this.requirementsTagProviders;
    }

    private List<RequirementsTagProvider> active(List<RequirementsTagProvider> requirementsProviders) {
        boolean useDirectoryBasedRequirements = this.environmentVariables.getPropertyAsBoolean(ThucydidesSystemProperty.USE_REQUIREMENTS_DIRECTORY, true);
        if (useDirectoryBasedRequirements) {
            return requirementsProviders;
        }
        List activeRequirementsProviders = Lists.newArrayList();
        for (RequirementsTagProvider provider : requirementsProviders) {
            if (provider instanceof FileSystemRequirementsTagProvider) continue;
            activeRequirementsProviders.add(provider);
        }
        return activeRequirementsProviders;
    }

    private List<RequirementsTagProvider> reprioritizeProviders(List<RequirementsTagProvider> requirementsTagProviders) {
        List lowPriorityProviders = Lists.newArrayList();
        List prioritizedProviders = Lists.newArrayList();
        for (RequirementsTagProvider provider : requirementsTagProviders) {
            if (LOW_PRIORITY_PROVIDERS.contains(provider.getClass().getCanonicalName())) {
                lowPriorityProviders.add(provider);
                continue;
            }
            prioritizedProviders.add(provider);
        }
        prioritizedProviders.addAll(lowPriorityProviders);
        return prioritizedProviders;
    }
}

