/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.AcceptanceTestLoader;
import net.thucydides.core.reports.OutcomeFormat;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.json.JSONTestOutcomeReporter;
import net.thucydides.core.reports.xml.XMLTestOutcomeReporter;
import net.thucydides.core.util.EnvironmentVariables;

public class TestOutcomeLoader {
    private final EnvironmentVariables environmentVariables;
    private final OutcomeFormat format;

    public TestOutcomeLoader() {
        this((EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    @Inject
    public TestOutcomeLoader(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.format = this.getFormat();
    }

    public List<TestOutcome> loadFrom(File reportDirectory) throws IOException {
        AcceptanceTestLoader testOutcomeReporter = this.getOutcomeReporter();
        List<File> reportFiles = this.getAllOutcomeFilesFrom(reportDirectory);
        ArrayList testOutcomes = Lists.newArrayList();
        for (File reportFile : reportFiles) {
            Optional<TestOutcome> testOutcome = testOutcomeReporter.loadReportFrom(reportFile);
            testOutcomes.addAll(testOutcome.asSet());
        }
        return ImmutableList.copyOf((Collection)testOutcomes);
    }

    private List<File> getAllOutcomeFilesFrom(File reportsDirectory) throws IOException {
        Object[] matchingFiles = reportsDirectory.listFiles(new SerializedOutcomeFilenameFilter());
        if (matchingFiles == null) {
            throw new IOException("Could not find directory " + reportsDirectory);
        }
        return ImmutableList.copyOf((Object[])matchingFiles);
    }

    public static TestOutcomes testOutcomesIn(File reportsDirectory) throws IOException {
        TestOutcomeLoader loader = new TestOutcomeLoader();
        return TestOutcomes.of(loader.loadFrom(reportsDirectory));
    }

    public AcceptanceTestLoader getOutcomeReporter() {
        switch (this.format) {
            case XML: {
                return new XMLTestOutcomeReporter();
            }
            case JSON: {
                return new JSONTestOutcomeReporter();
            }
        }
        throw new IllegalArgumentException("Unsupported report format: " + (Object)((Object)this.format));
    }

    private OutcomeFormat getFormat() {
        String formatValue = ThucydidesSystemProperty.THUCYDIDES_REPORT_FORMAT.from(this.environmentVariables, OutcomeFormat.XML.toString());
        return OutcomeFormat.valueOf(formatValue.toUpperCase());
    }

    private class SerializedOutcomeFilenameFilter
    implements FilenameFilter {
        private SerializedOutcomeFilenameFilter() {
        }

        @Override
        public boolean accept(File file, String filename) {
            return filename.toLowerCase(Locale.getDefault()).endsWith(TestOutcomeLoader.this.getFormat().getExtension());
        }
    }
}

