/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.util.EnvironmentVariables;

public class ReportOptions {
    private final boolean showStepDetails;
    private final boolean showManualTests;
    private final boolean showReleases;
    private final boolean showProgress;
    private final boolean showHistory;
    private final boolean showTagMenus;
    private final boolean showRelatedTags;
    private final String projectName;
    private RequirementsService requirementsService;

    public ReportOptions(EnvironmentVariables environmentVariables) {
        this.showStepDetails = Boolean.valueOf(ThucydidesSystemProperty.SHOW_STEP_DETAILS.from(environmentVariables, "false"));
        this.showManualTests = Boolean.valueOf(ThucydidesSystemProperty.SHOW_MANUAL_TESTS.from(environmentVariables, "true"));
        this.showReleases = Boolean.valueOf(ThucydidesSystemProperty.SHOW_RELEASES.from(environmentVariables, "true"));
        this.showProgress = Boolean.valueOf(ThucydidesSystemProperty.SHOW_PROGRESS.from(environmentVariables, "false"));
        this.showHistory = Boolean.valueOf(ThucydidesSystemProperty.SHOW_HISTORY.from(environmentVariables, "false"));
        this.showTagMenus = Boolean.valueOf(ThucydidesSystemProperty.SHOW_TAG_MENUS.from(environmentVariables, "false"));
        this.showRelatedTags = Boolean.valueOf(ThucydidesSystemProperty.SHOW_RELATED_TAGS.from(environmentVariables, "true"));
        this.projectName = ThucydidesSystemProperty.PROJECT_NAME.from(environmentVariables, "");
        this.requirementsService = (RequirementsService)Injectors.getInjector().getInstance(RequirementsService.class);
    }

    public boolean isShowStepDetails() {
        return this.showStepDetails;
    }

    public boolean isShowManualTests() {
        return this.showManualTests;
    }

    public boolean isShowReleases() {
        return this.showReleases || !this.requirementsService.getReleasesFromRequirements().isEmpty();
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public boolean isShowHistory() {
        return this.showHistory;
    }

    public boolean isShowTagMenus() {
        return this.showTagMenus;
    }

    public boolean isShowRelatedTags() {
        return this.showRelatedTags;
    }

    public String getProjectName() {
        return this.projectName;
    }
}

