package net.thucydides.core.statistics.service;

import com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.ServiceLoader;

public class ClasspathTagProviderService implements TagProviderService {

    private final Logger logger = LoggerFactory.getLogger(ClasspathTagProviderService.class);

    private List<TagProvider> tagProviders;

    public ClasspathTagProviderService() {
    }

    @Override
    public List<TagProvider> getTagProviders() {
        if (tagProviders == null) {
            tagProviders = Lists.newArrayList();

            ServiceLoader<TagProvider> tagProviderServiceLoader = ServiceLoader.load(TagProvider.class);

            for (TagProvider aServiceLoader : tagProviderServiceLoader) {
                logger.debug("Using tag provider: {}", aServiceLoader.getClass());
                tagProviders.add(aServiceLoader);
            }
        }
        return tagProviders;
    }
}
