/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.csv;

import au.com.bytecode.opencsv.CSVReader;
import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.thucydides.core.csv.FailedToInitializeTestData;
import net.thucydides.core.csv.FieldName;
import net.thucydides.core.csv.InstanceBuilder;
import net.thucydides.core.csv.TestDataSource;
import net.thucydides.core.steps.StepFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVTestDataSource
implements TestDataSource {
    private final List<Map<String, String>> testData;
    private final char separator;
    private final List<String> headers;
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVTestDataSource.class);

    public CSVTestDataSource(String path, char separatorValue) throws IOException {
        this.separator = separatorValue;
        List<String[]> csvDataRows = this.getCSVDataFrom(this.getDataFileFor(path));
        String[] titleRow = csvDataRows.get(0);
        this.headers = Lambda.convert((Object)titleRow, (Converter)new Converter<String, String>(){

            public String convert(String str) {
                return StringUtils.strip((String)str);
            }
        });
        this.testData = this.loadTestDataFrom(csvDataRows);
    }

    public CSVTestDataSource(String path) throws IOException {
        this(path, ',');
    }

    public static boolean validTestDataPath(String path) {
        if (CSVTestDataSource.validFileSystemPath(path) || CSVTestDataSource.isAClasspathResource(path)) {
            return true;
        }
        URL testDataUrl = CSVTestDataSource.class.getClassLoader().getResource(path);
        return testDataUrl != null && new File(testDataUrl.getFile()).exists();
    }

    private Reader getDataFileFor(String path) throws FileNotFoundException {
        Preconditions.checkNotNull((Object)path, (Object)"Test data source was not defined");
        if (CSVTestDataSource.isAClasspathResource(path)) {
            return new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(path));
        }
        if (CSVTestDataSource.validFileSystemPath(path)) {
            return new FileReader(new File(path));
        }
        throw new FileNotFoundException("Could not load test data from " + path);
    }

    private static boolean isAClasspathResource(String path) {
        return CSVTestDataSource.class.getClassLoader().getResourceAsStream(path) != null;
    }

    private static boolean validFileSystemPath(String path) {
        File file = new File(path);
        return file.exists();
    }

    protected List<String[]> getCSVDataFrom(Reader testDataReader) throws IOException {
        CSVReader reader = new CSVReader(testDataReader, this.separator);
        List rows = Lists.newArrayList();
        try {
            rows = reader.readAll();
        }
        finally {
            reader.close();
        }
        return rows;
    }

    protected List<Map<String, String>> loadTestDataFrom(List<String[]> rows) throws IOException {
        ArrayList<Map<String, String>> loadedData = new ArrayList<Map<String, String>>();
        String[] titleRow = rows.get(0);
        int i = 1;
        while (i < rows.size()) {
            String[] dataRow = rows.get(i);
            loadedData.add(this.dataEntryFrom(titleRow, dataRow));
            ++i;
        }
        return loadedData;
    }

    private Map<String, String> dataEntryFrom(String[] titleRow, String[] dataRow) {
        HashMap<String, String> dataset = new HashMap<String, String>();
        int column = 0;
        while (column < titleRow.length) {
            if (column < dataRow.length) {
                String title = titleRow[column].trim();
                String value = dataRow[column].trim();
                dataset.put(title, value);
            }
            ++column;
        }
        return dataset;
    }

    @Override
    public List<Map<String, String>> getData() {
        return this.testData;
    }

    @Override
    public List<String> getHeaders() {
        return this.headers;
    }

    @Override
    public <T> List<T> getDataAsInstancesOf(Class<T> clazz, Object ... constructorArgs) {
        List<Map<String, String>> data = this.getData();
        ArrayList<T> resultsList = new ArrayList<T>();
        for (Map<String, String> rowData : data) {
            resultsList.add(this.newInstanceFrom(clazz, rowData, constructorArgs));
        }
        return resultsList;
    }

    @Override
    public <T> List<T> getInstanciatedInstancesFrom(Class<T> clazz, StepFactory factory) {
        List<Map<String, String>> data = this.getData();
        ArrayList<T> resultsList = new ArrayList<T>();
        for (Map<String, String> rowData : data) {
            resultsList.add(this.newInstanceFrom(clazz, factory, rowData));
        }
        return resultsList;
    }

    private <T> T newInstanceFrom(Class<T> clazz, Map<String, String> rowData, Object ... constructorArgs) {
        T newObject = this.createNewInstanceOf(clazz, constructorArgs);
        this.assignPropertiesFromTestData(clazz, rowData, newObject);
        return newObject;
    }

    private <T> T newInstanceFrom(Class<T> clazz, StepFactory factory, Map<String, String> rowData) {
        T newObject = factory.getUniqueStepLibraryFor(clazz);
        this.assignPropertiesFromTestData(clazz, rowData, newObject);
        return newObject;
    }

    private <T> void assignPropertiesFromTestData(Class<T> clazz, Map<String, String> rowData, T newObject) {
        Set<String> propertyNames = rowData.keySet();
        boolean validPropertyFound = false;
        for (String columnHeading : propertyNames) {
            String value = rowData.get(columnHeading);
            String property = FieldName.from(columnHeading).inNormalizedForm();
            if (!this.assignPropertyValue(newObject, property, value)) continue;
            validPropertyFound = true;
        }
        if (!validPropertyFound) {
            throw new FailedToInitializeTestData("No properties or public fields matching the data columns were found or could be assigned for the class " + clazz.getName() + "using test data: " + rowData);
        }
    }

    protected <T> T createNewInstanceOf(Class<T> clazz, Object ... constructorArgs) {
        try {
            return InstanceBuilder.newInstanceOf(clazz, constructorArgs);
        }
        catch (Exception e) {
            LOGGER.error("Could not create test data bean", (Throwable)e);
            throw new FailedToInitializeTestData("Could not create test data beans", e);
        }
    }

    protected <T> boolean assignPropertyValue(T newObject, String property, String value) {
        boolean valueWasAssigned = true;
        try {
            InstanceBuilder.inObject(newObject).setPropertyValue(property, value);
        }
        catch (FailedToInitializeTestData failedToInitializeTestData) {
            valueWasAssigned = false;
        }
        return valueWasAssigned;
    }
}

