/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.adaptors.xunit;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.reports.adaptors.common.FilebasedOutcomeAdaptor;
import net.thucydides.core.reports.adaptors.xunit.BasicXUnitLoader;
import net.thucydides.core.reports.adaptors.xunit.XUnitLoader;
import net.thucydides.core.reports.adaptors.xunit.io.XUnitFiles;
import net.thucydides.core.reports.adaptors.xunit.model.TestCase;
import net.thucydides.core.reports.adaptors.xunit.model.TestException;
import net.thucydides.core.reports.adaptors.xunit.model.TestSuite;
import net.thucydides.core.util.NameConverter;

public class DefaultXUnitAdaptor
extends FilebasedOutcomeAdaptor {
    private final XUnitLoader loader = new BasicXUnitLoader();

    @Override
    public List<TestOutcome> loadOutcomesFrom(File source) throws IOException {
        ArrayList loadedOutcomes = Lists.newArrayList();
        File[] fileArray = XUnitFiles.in(source);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File xunitFile = fileArray[n2];
            loadedOutcomes.addAll(this.testOutcomesIn(xunitFile));
            ++n2;
        }
        return ImmutableList.copyOf((Collection)loadedOutcomes);
    }

    public List<TestOutcome> testOutcomesIn(File xunitFile) throws IOException {
        List<TestSuite> xunitTestSuites = this.loader.loadFrom(xunitFile);
        ArrayList testOutcomes = Lists.newArrayList();
        for (TestSuite testSuite : xunitTestSuites) {
            testOutcomes.addAll(this.testOutcomesIn(testSuite));
        }
        return ImmutableList.copyOf((Collection)testOutcomes);
    }

    private Collection<? extends TestOutcome> testOutcomesIn(TestSuite testSuite) {
        return Lambda.convert(testSuite.getTestCases(), this.toTestOutcomes());
    }

    private Converter<TestCase, TestOutcome> toTestOutcomes() {
        return new Converter<TestCase, TestOutcome>(){

            public TestOutcome convert(TestCase from) {
                TestOutcome outcome = TestOutcome.forTestInStory(from.getName(), Story.called(from.getClassname()));
                outcome.setTitle(NameConverter.humanize(from.getName()));
                outcome.setDuration(DefaultXUnitAdaptor.this.timeAsLong(from.getTime()));
                if (from.getError().isPresent()) {
                    TestException failure = (TestException)from.getError().get();
                    outcome.setTestFailureCause(failure.asException());
                } else if (from.getFailure().isPresent()) {
                    TestException failure = (TestException)from.getFailure().get();
                    outcome.setTestFailureCause(failure.asAssertionFailure());
                } else if (from.getSkipped().isPresent()) {
                    outcome.setAnnotatedResult(TestResult.PENDING);
                } else {
                    outcome.setAnnotatedResult(TestResult.SUCCESS);
                }
                return outcome;
            }
        };
    }

    private long timeAsLong(double time) {
        return time < 1.0 ? 1L : (long)time;
    }
}

