/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.screenshots;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.jhlabs.image.BoxBlurFilter;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.screenshots.BlurLevel;
import net.thucydides.core.screenshots.QueuedScreenshot;
import net.thucydides.core.screenshots.ScreenshotDigest;
import net.thucydides.core.screenshots.ScreenshotProcessor;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.ProvidedDriverConfiguration;
import net.thucydides.core.webdriver.WebDriverFacade;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Photographer {
    private final WebDriver driver;
    private final File targetDirectory;
    private Optional<BlurLevel> blurLevel;
    private final Logger logger = LoggerFactory.getLogger(Photographer.class);
    private ScreenshotProcessor screenshotProcessor;
    private EnvironmentVariables environmentVariables;

    protected Logger getLogger() {
        return this.logger;
    }

    public Photographer(WebDriver driver, File targetDirectory) {
        this(driver, targetDirectory, (ScreenshotProcessor)Injectors.getInjector().getInstance(ScreenshotProcessor.class), null);
    }

    public Photographer(WebDriver driver, File targetDirectory, BlurLevel blurLevel) {
        this(driver, targetDirectory, (ScreenshotProcessor)Injectors.getInjector().getInstance(ScreenshotProcessor.class), blurLevel);
    }

    public Photographer(WebDriver driver, File targetDirectory, ScreenshotProcessor screenshotProcessor) {
        this(driver, targetDirectory, screenshotProcessor, null);
    }

    public Photographer(WebDriver driver, File targetDirectory, ScreenshotProcessor screenshotProcessor, BlurLevel blurLevel) {
        this(driver, targetDirectory, screenshotProcessor, blurLevel, (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    public Photographer(WebDriver driver, File targetDirectory, ScreenshotProcessor screenshotProcessor, BlurLevel blurLevel, EnvironmentVariables environmentVariables) {
        Preconditions.checkNotNull((Object)targetDirectory);
        Preconditions.checkNotNull((Object)screenshotProcessor);
        this.driver = driver;
        this.targetDirectory = targetDirectory;
        this.screenshotProcessor = screenshotProcessor;
        this.blurLevel = Optional.fromNullable((Object)((Object)blurLevel));
        this.environmentVariables = environmentVariables;
    }

    public Optional<BlurLevel> getBlurLevel() {
        return this.blurLevel;
    }

    public Optional<File> takeScreenshot() {
        if (this.driverCanTakeSnapshots()) {
            try {
                File screenshotTempFile = null;
                Object capturedScreenshot = ((TakesScreenshot)this.driver).getScreenshotAs(OutputType.FILE);
                if (this.isAFile(capturedScreenshot)) {
                    screenshotTempFile = (File)capturedScreenshot;
                } else if (this.isByteArray(capturedScreenshot)) {
                    screenshotTempFile = this.saveScreenshotData((byte[])capturedScreenshot);
                }
                if (screenshotTempFile != null && this.blurLevel.isPresent()) {
                    screenshotTempFile = this.blur(screenshotTempFile);
                }
                if (screenshotTempFile != null) {
                    String storedFilename = this.getDigestScreenshotNameFor(screenshotTempFile);
                    File savedScreenshot = this.targetScreenshot(storedFilename);
                    this.screenshotProcessor.queueScreenshot(new QueuedScreenshot(screenshotTempFile, savedScreenshot));
                    return Optional.of((Object)savedScreenshot);
                }
            }
            catch (Throwable e) {
                this.getLogger().warn("Failed to write screenshot (possibly an out of memory error): " + e.getMessage());
            }
        }
        return Optional.absent();
    }

    private String getDigestScreenshotNameFor(File screenshotTempFile) throws IOException {
        ScreenshotDigest screenshotDigest = new ScreenshotDigest(this.environmentVariables, (BlurLevel)((Object)this.blurLevel.orNull()));
        return screenshotDigest.forScreenshot(screenshotTempFile);
    }

    protected File blur(File srcFile) throws IOException {
        BufferedImage srcImage = ImageIO.read(srcFile);
        BufferedImage destImage = this.deepCopy(srcImage);
        BoxBlurFilter boxBlurFilter = new BoxBlurFilter();
        boxBlurFilter.setRadius(((BlurLevel)((Object)this.blurLevel.get())).getRadius());
        boxBlurFilter.setIterations(3);
        destImage = boxBlurFilter.filter(srcImage, destImage);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)destImage, "png", outStream);
        return this.saveScreenshotData(outStream.toByteArray());
    }

    private BufferedImage deepCopy(BufferedImage srcImage) {
        ColorModel cm = srcImage.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = srcImage.copyData(null);
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
    }

    private File saveScreenshotData(byte[] capturedScreenshot) throws IOException {
        String screenshotTempFileName = "screenshot_" + UUID.randomUUID();
        File screenshotFile = new File(FileUtils.getTempDirectory(), screenshotTempFileName);
        byte[] screenshotData = capturedScreenshot;
        screenshotFile.deleteOnExit();
        if (screenshotData.length > 0) {
            FileUtils.writeByteArrayToFile((File)screenshotFile, (byte[])screenshotData);
        } else {
            FileUtils.touch((File)screenshotFile);
        }
        return screenshotFile;
    }

    private boolean isAFile(Object screenshot) {
        return screenshot instanceof File;
    }

    private boolean isByteArray(Object screenshot) {
        return screenshot instanceof byte[];
    }

    private File targetScreenshot(String storedFilename) {
        this.targetDirectory.mkdirs();
        return new File(this.targetDirectory, storedFilename);
    }

    protected boolean driverCanTakeSnapshots() {
        if (this.driver == null) {
            return false;
        }
        if (this.driverIsProvided()) {
            ProvidedDriverConfiguration sourceConfig = new ProvidedDriverConfiguration(this.environmentVariables);
            return sourceConfig.getDriverSource().takesScreenshots();
        }
        if (this.driver instanceof WebDriverFacade) {
            return ((WebDriverFacade)this.driver).canTakeScreenshots() && ((WebDriverFacade)this.driver).getProxiedDriver() != null;
        }
        return TakesScreenshot.class.isAssignableFrom(this.driver.getClass());
    }

    private boolean driverIsProvided() {
        return false;
    }

    private String sourceCodeFileFor(File screenshotFile) throws IOException {
        String rootFilename = DigestUtils.md5Hex((InputStream)new FileInputStream(screenshotFile));
        return String.valueOf(rootFilename) + ".html";
    }

    public File getMatchingSourceCodeFor(File screenshot) throws IOException {
        if (screenshot != null) {
            return new File(this.sourceCodeFileFor(screenshot));
        }
        return null;
    }

    public void setScreenshotProcessor(ScreenshotProcessor screenshotProcessor) {
        this.screenshotProcessor = screenshotProcessor;
    }

    protected ScreenshotProcessor getScreenshotProcessor() {
        return this.screenshotProcessor;
    }
}

