/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.screenshots;

import com.google.common.base.Optional;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.screenshots.BlurLevel;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.codec.digest.DigestUtils;

public class ScreenshotDigest {
    private final Optional<BlurLevel> blurLevel;
    private final EnvironmentVariables environmentVariables;

    public ScreenshotDigest(EnvironmentVariables environmentVariables, BlurLevel blurLevel) {
        this.environmentVariables = environmentVariables;
        this.blurLevel = Optional.fromNullable((Object)((Object)blurLevel));
    }

    public String forScreenshot(File screenshotFile) throws IOException {
        return String.valueOf(DigestUtils.md5Hex((InputStream)new FileInputStream(screenshotFile))) + "_" + ((BlurLevel)((Object)this.blurLevel.or((Object)BlurLevel.NONE))).toString() + this.optionalWidth() + ".png";
    }

    private String optionalWidth() {
        return this.environmentVariables.getProperty(ThucydidesSystemProperty.RESIZED_WIDTH, "");
    }
}

