/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.common.base.Preconditions;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.DriverSource;

public class ProvidedDriverConfiguration {
    private final EnvironmentVariables environmentVariables;

    public ProvidedDriverConfiguration(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public boolean isProvided() {
        return ThucydidesSystemProperty.DRIVER.from(this.environmentVariables, "").equals("provided");
    }

    public DriverSource getDriverSource() {
        String providedDriverType = this.getDriverName();
        Preconditions.checkNotNull((Object)providedDriverType, (Object)"No provider type was specified in 'webdriver.provided.type'");
        String providedImplementation = this.environmentVariables.getProperty("webdriver.provided." + providedDriverType);
        Preconditions.checkNotNull((Object)providedImplementation, (Object)("No provider implementation was specified in 'webdriver.provided.'" + providedDriverType));
        try {
            return (DriverSource)Class.forName(providedImplementation).newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not instantiate the custom webdriver provider of type " + providedImplementation);
        }
    }

    public String getDriverName() {
        return this.environmentVariables.getProperty(ThucydidesSystemProperty.PROVIDED_DRIVER_TYPE);
    }
}

