/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.matchers;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.thucydides.core.matchers.BeanCollectionMatcher;
import net.thucydides.core.matchers.dates.BeanFields;
import org.hamcrest.Matcher;

class MaxFieldValueMatcher
implements BeanCollectionMatcher {
    private final String fieldName;
    private final Matcher<? extends Comparable> valueMatcher;

    public MaxFieldValueMatcher(String fieldName, Matcher<? extends Comparable> valueMatcher) {
        this.fieldName = fieldName;
        this.valueMatcher = valueMatcher;
    }

    @Override
    public boolean matches(Object target) {
        return this.matches((Collection)target);
    }

    @Override
    public <T> boolean matches(Collection<T> elements) {
        Comparable maximumValue = null;
        try {
            List fieldValues = Lambda.convert(elements, this.toComparable());
            maximumValue = (Comparable)Collections.max(fieldValues);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not find property value for " + this.fieldName);
        }
        return this.valueMatcher.matches((Object)maximumValue);
    }

    private <T> Converter<T, Comparable> toComparable() {
        return new Converter<T, Comparable>(){

            public Comparable convert(T bean) {
                return (Comparable)BeanFields.fieldValueIn(bean).forField(MaxFieldValueMatcher.this.fieldName);
            }
        };
    }

    public String toString() {
        return "the maximum " + this.fieldName + " " + this.valueMatcher.toString();
    }
}

