/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.statistics.service;

import com.beust.jcommander.internal.Lists;
import java.util.List;
import java.util.ServiceLoader;
import net.thucydides.core.requirements.CoreTagProvider;
import net.thucydides.core.requirements.OverridableTagProvider;
import net.thucydides.core.statistics.service.TagProvider;
import net.thucydides.core.statistics.service.TagProviderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathTagProviderService
implements TagProviderService {
    private final Logger logger = LoggerFactory.getLogger(ClasspathTagProviderService.class);
    private List<TagProvider> tagProviders;

    @Override
    public List<TagProvider> getTagProviders() {
        if (this.tagProviders == null) {
            List<Object> newTagProviders = com.google.common.collect.Lists.newArrayList();
            Iterable<TagProvider> tagProviderServiceLoader = this.loadTagProvidersFromPath();
            for (TagProvider aServiceLoader : tagProviderServiceLoader) {
                newTagProviders.add(aServiceLoader);
            }
            if (this.additionalTagProvidersArePresentIn(newTagProviders)) {
                newTagProviders = this.removeOverridableProvidersFrom(newTagProviders);
            }
            this.tagProviders = newTagProviders;
        }
        return this.tagProviders;
    }

    protected Iterable<TagProvider> loadTagProvidersFromPath() {
        return ServiceLoader.load(TagProvider.class);
    }

    private boolean additionalTagProvidersArePresentIn(List<TagProvider> providers) {
        for (TagProvider provider : providers) {
            if (this.isKnownProvider(provider)) continue;
            return true;
        }
        return false;
    }

    private boolean isKnownProvider(TagProvider provider) {
        return CoreTagProvider.class.isAssignableFrom(provider.getClass());
    }

    private List<TagProvider> removeOverridableProvidersFrom(List<TagProvider> providers) {
        List retainedProviders = Lists.newArrayList();
        for (TagProvider provider : providers) {
            if (OverridableTagProvider.class.isAssignableFrom(provider.getClass())) continue;
            retainedProviders.add(provider);
        }
        return retainedProviders;
    }
}

