/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.adaptors.specflow;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.List;
import net.thucydides.core.model.TestResult;

public class ScenarioStep {
    private static final String SUCCESS_LEAD = "-> done: ";
    private static final String PENDING_LEAD = "-> No matching step definition";
    private static final String FAILURE_LEAD = "-> error: ";
    private static final String SKIPPED_LEAD = "-> skipped";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final String title;
    private final TestResult result;
    private final Optional<? extends Throwable> exception;
    private final Optional<BigDecimal> duration;

    public ScenarioStep(List<String> resultLines) {
        this.title = resultLines.get(0).trim();
        this.duration = this.parseDuration(this.tail(resultLines));
        this.result = this.parseResult(this.tail(resultLines));
        this.exception = this.parseException(this.tail(resultLines));
    }

    private Optional<BigDecimal> parseDuration(List<String> resultLines) {
        String resultLine = resultLines.get(0);
        if (this.containsDurationValue(resultLine)) {
            String durationText = resultLine.substring(resultLine.lastIndexOf("(") + 1);
            durationText = durationText.substring(0, durationText.lastIndexOf("s)"));
            BigDecimal durationValue = new BigDecimal(durationText).multiply(new BigDecimal("1000")).round(new MathContext(0, RoundingMode.HALF_UP));
            return Optional.of((Object)durationValue);
        }
        return Optional.absent();
    }

    private boolean containsDurationValue(String resultLine) {
        return resultLine.lastIndexOf("(") > 0 && resultLine.lastIndexOf("s)") > 0;
    }

    private TestResult parseResult(List<String> resultLines) {
        String firstLine = resultLines.get(0).trim();
        if (firstLine.startsWith(SUCCESS_LEAD)) {
            return TestResult.SUCCESS;
        }
        if (firstLine.startsWith(PENDING_LEAD)) {
            return TestResult.PENDING;
        }
        if (firstLine.startsWith(FAILURE_LEAD)) {
            return TestResult.FAILURE;
        }
        if (firstLine.startsWith(SKIPPED_LEAD)) {
            return TestResult.SKIPPED;
        }
        return TestResult.UNDEFINED;
    }

    private Optional<? extends Throwable> parseException(List<String> resultLines) {
        String firstLine = resultLines.get(0).trim();
        if (firstLine.startsWith(FAILURE_LEAD)) {
            StringBuilder errorMessage = new StringBuilder(firstLine.substring(FAILURE_LEAD.length()));
            int i = 1;
            while (i < resultLines.size()) {
                errorMessage.append(NEW_LINE);
                errorMessage.append(resultLines.get(i));
                ++i;
            }
            return Optional.of((Object)new AssertionError((Object)errorMessage.toString()));
        }
        return Optional.absent();
    }

    public Optional<BigDecimal> getDuration() {
        return this.duration;
    }

    public TestResult getResult() {
        return this.result;
    }

    public String getTitle() {
        return this.title;
    }

    public Optional<? extends Throwable> getException() {
        return this.exception;
    }

    private List<String> tail(List<String> lines) {
        return ImmutableList.copyOf(lines.subList(1, lines.size()));
    }
}

