/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.batches;

import com.google.inject.Inject;
import com.google.inject.Provider;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.batches.BatchManager;
import net.thucydides.core.batches.BatchStrategy;
import net.thucydides.core.batches.UnsupportedBatchStrategyException;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;

public class BatchManagerProvider
implements Provider<BatchManager> {
    private final BatchManager batchManager;

    @Inject
    public BatchManagerProvider(Configuration configuration) {
        EnvironmentVariables environmentVariables = configuration.getEnvironmentVariables();
        String batchManagerProperty = ThucydidesSystemProperty.THUCYDIDES_BATCH_STRATEGY.from(environmentVariables, BatchStrategy.DIVIDE_EQUALLY.name());
        try {
            this.batchManager = BatchStrategy.valueOf(batchManagerProperty).instance(environmentVariables);
        }
        catch (Exception e) {
            throw new UnsupportedBatchStrategyException(String.valueOf(batchManagerProperty) + " is not a supported batch strategy.", e);
        }
    }

    public BatchManager get() {
        return this.batchManager;
    }
}

