/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.images;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.thucydides.core.images.ResizedImage;
import net.thucydides.core.images.SimpleImageInfo;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResizableImage {
    private final File screenshotFile;
    private final SimpleImageInfo imageInfo;
    private final int MAX_SUPPORTED_HEIGHT = 4000;
    private final Logger logger = LoggerFactory.getLogger(ResizableImage.class);

    protected Logger getLogger() {
        return this.logger;
    }

    public ResizableImage(File screenshotFile) throws IOException {
        this.screenshotFile = screenshotFile;
        this.imageInfo = new SimpleImageInfo(screenshotFile);
    }

    public static ResizableImage loadFrom(File screenshotFile) throws IOException {
        return new ResizableImage(screenshotFile);
    }

    public int getWitdh() {
        return this.imageInfo.getWidth();
    }

    public int getHeight() {
        return this.imageInfo.getHeight();
    }

    public ResizableImage rescaleCanvas(int height) throws IOException {
        if (this.skipRescale(height)) {
            return this;
        }
        int targetHeight = Math.min(height, 4000);
        BufferedImage image = ImageIO.read(this.screenshotFile);
        int width = new SimpleImageInfo(this.screenshotFile).getWidth();
        try {
            return this.resizeImage(width, targetHeight, image);
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warn("Could not resize screenshot: " + this.screenshotFile, (Throwable)e);
            return this;
        }
    }

    protected ResizableImage resizeImage(int width, int targetHeight, BufferedImage image) throws IOException {
        try {
            int imageType = image.getType() > 0 ? image.getType() : 6;
            BufferedImage resizedImage = new BufferedImage(width, targetHeight, imageType);
            this.fillWithWhiteBackground(resizedImage);
            resizedImage.setData(image.getRaster());
            return new ResizedImage(resizedImage, this.screenshotFile);
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException();
        }
    }

    private boolean skipRescale(int height) {
        if (this.getHeight() > 4000) {
            return true;
        }
        return this.getHeight() >= height;
    }

    private void fillWithWhiteBackground(BufferedImage resizedImage) {
        Graphics2D g2d = resizedImage.createGraphics();
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.fill(new Rectangle2D.Float(0.0f, 0.0f, resizedImage.getWidth(), resizedImage.getHeight()));
        g2d.dispose();
    }

    public void saveTo(File savedFile) throws IOException {
        FileUtils.copyFile((File)this.screenshotFile, (File)savedFile);
    }
}

