/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.TestAnnotations;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.images.SimpleImageInfo;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.DataTableRow;
import net.thucydides.core.model.FailureAnalysis;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.Screenshot;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestDuration;
import net.thucydides.core.model.TestOutcomeAnnotationReader;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.model.TestType;
import net.thucydides.core.model.features.ApplicationFeature;
import net.thucydides.core.pages.SystemClock;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.reports.json.JSONConverter;
import net.thucydides.core.reports.saucelabs.LinkGenerator;
import net.thucydides.core.screenshots.ScreenshotAndHtmlSource;
import net.thucydides.core.statistics.model.TestStatistics;
import net.thucydides.core.statistics.service.TagProvider;
import net.thucydides.core.statistics.service.TagProviderService;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepFailureException;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestOutcome {
    private static final int RECENT_TEST_RUN_COUNT = 10;
    private static final String ISSUES = "issues";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final String methodName;
    private final Class<?> testCase;
    private final List<TestStep> testSteps = new ArrayList<TestStep>();
    private Story userStory;
    private String title;
    private String description;
    private List<String> issues;
    private List<String> additionalIssues;
    private List<String> versions;
    private List<String> additionalVersions;
    private Set<TestTag> tags;
    private long startTime;
    private long duration;
    private long testRunTimestamp;
    private String project;
    private Throwable testFailureCause;
    private TestResult annotatedResult = null;
    private Stack<TestStep> groupStack = new Stack();
    private IssueTracking issueTracking;
    private EnvironmentVariables environmentVariables;
    private String sessionId;
    private LinkGenerator linkGenerator;
    private TestStatistics statistics;
    private TagProviderService tagProviderService;
    private Optional<String> qualifier;
    private DataTable dataTable;
    private boolean manualTest;
    private final Logger logger = LoggerFactory.getLogger(TestOutcome.class);
    Optional<DateTime> NO_BATCH_START_TIME = Optional.absent();
    private final List<String> NO_HEADERS = Lists.newArrayList();

    public TestOutcome(String methodName) {
        this(methodName, null);
    }

    public TestOutcome(String methodName, Class<?> testCase) {
        this.startTime = this.now();
        this.methodName = methodName;
        this.testCase = testCase;
        this.additionalIssues = Lists.newArrayList();
        this.additionalVersions = Lists.newArrayList();
        this.issueTracking = (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class);
        this.linkGenerator = (LinkGenerator)Injectors.getInjector().getInstance(LinkGenerator.class);
        this.qualifier = Optional.absent();
        if (testCase != null) {
            this.initializeStoryFrom(testCase);
        }
    }

    private TagProviderService getTagProviderService() {
        if (this.tagProviderService == null) {
            this.tagProviderService = (TagProviderService)Injectors.getInjector().getInstance(TagProviderService.class);
        }
        return this.tagProviderService;
    }

    public TestOutcome usingIssueTracking(IssueTracking issueTracking) {
        this.issueTracking = issueTracking;
        return this;
    }

    public TestOutcome asManualTest() {
        this.manualTest = true;
        return this;
    }

    public void setEnvironmentVariables(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public EnvironmentVariables getEnvironmentVariables() {
        if (this.environmentVariables == null) {
            this.environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
        }
        return this.environmentVariables;
    }

    protected TestOutcome(String methodName, Class<?> testCase, Story userStory) {
        this.startTime = this.now();
        this.methodName = methodName;
        this.testCase = testCase;
        this.additionalIssues = Lists.newArrayList();
        this.additionalVersions = Lists.newArrayList();
        this.userStory = userStory;
        this.issueTracking = (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class);
        this.linkGenerator = (LinkGenerator)Injectors.getInjector().getInstance(LinkGenerator.class);
    }

    protected TestOutcome(long startTime, long duration, String title, String description, String methodName, Class<?> testCase, List<TestStep> testSteps, List<String> issues, List<String> additionalIssues, Set<TestTag> tags, Story userStory, Throwable testFailureCause, TestResult annotatedResult, DataTable dataTable, Optional<String> qualifier, boolean manualTest) {
        this.startTime = startTime;
        this.duration = duration;
        this.title = title;
        this.description = description;
        this.methodName = methodName;
        this.testCase = testCase;
        this.addSteps(testSteps);
        this.issues = this.removeDuplicates(issues);
        this.additionalVersions = this.removeDuplicates(this.additionalVersions);
        this.additionalIssues = additionalIssues;
        this.tags = tags;
        this.userStory = userStory;
        this.testFailureCause = testFailureCause;
        this.qualifier = qualifier;
        this.annotatedResult = annotatedResult;
        this.dataTable = dataTable;
        this.issueTracking = (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class);
        this.linkGenerator = (LinkGenerator)Injectors.getInjector().getInstance(LinkGenerator.class);
        this.manualTest = manualTest;
    }

    private List<String> removeDuplicates(List<String> issues) {
        ArrayList issuesWithNoDuplicates = Lists.newArrayList();
        if (issues != null) {
            for (String issue : issues) {
                if (issuesWithNoDuplicates.contains(issue)) continue;
                issuesWithNoDuplicates.add(issue);
            }
        }
        return issuesWithNoDuplicates;
    }

    public static TestOutcome forTest(String methodName, Class<?> testCase) {
        return new TestOutcome(methodName, testCase);
    }

    public TestOutcome withQualifier(String qualifier) {
        if (qualifier != null) {
            return new TestOutcome(this.startTime, this.duration, this.title, this.description, this.methodName, this.testCase, this.testSteps, this.issues, this.additionalIssues, this.tags, this.userStory, this.testFailureCause, this.annotatedResult, this.dataTable, (Optional<String>)Optional.fromNullable((Object)qualifier), this.manualTest);
        }
        return this;
    }

    public TestOutcome withIssues(List<String> issues) {
        return new TestOutcome(this.startTime, this.duration, this.title, this.description, this.methodName, this.testCase, this.testSteps, (List<String>)ImmutableList.copyOf(issues), this.additionalIssues, this.tags, this.userStory, this.testFailureCause, this.annotatedResult, this.dataTable, this.qualifier, this.manualTest);
    }

    public TestOutcome withMethodName(String methodName) {
        if (methodName != null) {
            return new TestOutcome(this.startTime, this.duration, this.title, this.description, methodName, this.testCase, this.getTestSteps(), this.issues, this.additionalIssues, this.tags, this.userStory, this.testFailureCause, this.annotatedResult, this.dataTable, this.qualifier, this.manualTest);
        }
        return this;
    }

    private void initializeStoryFrom(Class<?> testCase) {
        Story story = Story.testedInTestCase(testCase) != null ? Story.from(Story.testedInTestCase(testCase)) : Story.from(testCase);
        this.setUserStory(story);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public static TestOutcome forTestInStory(String testName, Story story) {
        return new TestOutcome(testName, null, story);
    }

    public static TestOutcome forTestInStory(String testName, Class<?> testCase, Story story) {
        return new TestOutcome(testName, testCase, story);
    }

    public String toString() {
        return String.valueOf(this.getTitle()) + ":" + Lambda.join((Object)Lambda.extract(this.testSteps, (Object)((TestStep)Lambda.on(TestStep.class)).toString()));
    }

    public String toJson() {
        return new JSONConverter().toJson(this);
    }

    public String getTitle() {
        if (this.title == null) {
            return this.obtainTitleFromAnnotationOrMethodName();
        }
        return this.title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Optional<String> getDescriptionText() {
        if (this.getDescription() != null) {
            return Optional.of((Object)this.description);
        }
        if (this.title != null) {
            return this.getDescriptionFrom(this.title);
        }
        return Optional.absent();
    }

    private Optional<String> getDescriptionFrom(String storedTitle) {
        ArrayList multilineTitle = Lists.newArrayList((Iterable)Splitter.on((Pattern)Pattern.compile("\r?\n")).split((CharSequence)storedTitle));
        if (multilineTitle.size() > 1) {
            multilineTitle.remove(0);
            return Optional.of((Object)Joiner.on((String)NEW_LINE).join((Iterable)multilineTitle));
        }
        return Optional.absent();
    }

    public String getTitleWithLinks() {
        return this.getFormatter().addLinks(this.getTitle());
    }

    private Formatter getFormatter() {
        return new Formatter(this.issueTracking);
    }

    private String obtainTitleFromAnnotationOrMethodName() {
        Optional<String> annotatedTitle = TestAnnotations.forClass(this.testCase).getAnnotatedTitleForMethod(this.methodName);
        String rootTitle = (String)annotatedTitle.or((Object)NameConverter.humanize(NameConverter.withNoArguments(this.methodName)));
        if (this.qualifier != null && this.qualifier.isPresent()) {
            return this.qualified(rootTitle);
        }
        return rootTitle;
    }

    private String qualified(String rootTitle) {
        return String.valueOf(rootTitle) + " [" + (String)this.qualifier.get() + "]";
    }

    public String getStoryTitle() {
        return this.userStory != null ? this.getTitleFrom(this.userStory) : "";
    }

    public String getPath() {
        if (this.userStory != null) {
            return this.userStory.getPath();
        }
        return null;
    }

    public String getPathId() {
        if (this.userStory != null) {
            return this.userStory.getId();
        }
        return this.getPath();
    }

    private String getTitleFrom(Story userStory) {
        return userStory.getName() == null ? "" : userStory.getName();
    }

    public String getReportName(ReportType type) {
        return ReportNamer.forReportType(type).getNormalizedTestNameFor(this);
    }

    public String getSimpleReportName(ReportType type) {
        ReportNamer reportNamer = ReportNamer.forReportType(type);
        return reportNamer.getSimpleTestNameFor(this);
    }

    public String getHtmlReport() {
        return this.getReportName(ReportType.HTML);
    }

    public String getReportName() {
        return this.getReportName(ReportType.ROOT);
    }

    public String getScreenshotReportName() {
        return String.valueOf(this.getReportName(ReportType.ROOT)) + "_screenshots";
    }

    public List<TestStep> getTestSteps() {
        return ImmutableList.copyOf(this.testSteps);
    }

    public boolean hasScreenshots() {
        return !this.getScreenshots().isEmpty();
    }

    public List<ScreenshotAndHtmlSource> getScreenshotAndHtmlSources() {
        List testStepsWithScreenshots = Lambda.select(this.getFlattenedTestSteps(), (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).needsScreenshots()));
        return Lambda.flatten((Object)Lambda.extract((Object)testStepsWithScreenshots, ((TestStep)Lambda.on(TestStep.class)).getScreenshots()));
    }

    public List<Screenshot> getScreenshots() {
        ArrayList<Screenshot> screenshots = new ArrayList<Screenshot>();
        List testStepsWithScreenshots = Lambda.select(this.getFlattenedTestSteps(), (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).needsScreenshots()));
        for (TestStep currentStep : testStepsWithScreenshots) {
            screenshots.addAll(this.screenshotsIn(currentStep));
        }
        return ImmutableList.copyOf(screenshots);
    }

    private List<Screenshot> screenshotsIn(TestStep currentStep) {
        return Lambda.convert(currentStep.getScreenshots(), this.toScreenshotsFor(currentStep));
    }

    private Converter<ScreenshotAndHtmlSource, Screenshot> toScreenshotsFor(final TestStep currentStep) {
        return new Converter<ScreenshotAndHtmlSource, Screenshot>(){

            public Screenshot convert(ScreenshotAndHtmlSource from) {
                return new Screenshot(from.getScreenshotFile().getName(), currentStep.getDescription(), TestOutcome.this.widthOf(from.getScreenshotFile()), currentStep.getException());
            }
        };
    }

    private int widthOf(File screenshot) {
        try {
            return new SimpleImageInfo(screenshot).getWidth();
        }
        catch (IOException iOException) {
            return 960;
        }
    }

    public boolean hasNonStepFailure() {
        boolean stepsContainFailure = false;
        for (TestStep step : this.getFlattenedTestSteps()) {
            if (step.getResult() != TestResult.FAILURE && step.getResult() != TestResult.ERROR) continue;
            stepsContainFailure = true;
        }
        return !stepsContainFailure && (this.getResult() == TestResult.ERROR || this.getResult() == TestResult.FAILURE);
    }

    public List<TestStep> getFlattenedTestSteps() {
        ArrayList<? extends TestStep> flattenedTestSteps = new ArrayList<TestStep>();
        for (TestStep step : this.getTestSteps()) {
            flattenedTestSteps.add(step);
            if (!step.isAGroup()) continue;
            flattenedTestSteps.addAll(step.getFlattenedSteps());
        }
        return ImmutableList.copyOf(flattenedTestSteps);
    }

    public List<TestStep> getLeafTestSteps() {
        ArrayList<? extends TestStep> leafTestSteps = new ArrayList<TestStep>();
        for (TestStep step : this.getTestSteps()) {
            if (step.isAGroup()) {
                leafTestSteps.addAll(step.getLeafTestSteps());
                continue;
            }
            leafTestSteps.add(step);
        }
        return ImmutableList.copyOf(leafTestSteps);
    }

    public TestResult getResult() {
        if (this.testFailureCause != null) {
            return new FailureAnalysis().resultFor(this.testFailureCause);
        }
        if (this.annotatedResult != null) {
            return this.annotatedResult;
        }
        TestResultList testResults = TestResultList.of(this.getCurrentTestResults());
        return testResults.getOverallResult();
    }

    public TestOutcome recordSteps(List<TestStep> steps) {
        for (TestStep step : steps) {
            this.recordStep(step);
        }
        return this;
    }

    public TestOutcome recordStep(TestStep step) {
        Preconditions.checkNotNull((Object)step.getDescription(), (Object)"The test step description was not defined.");
        if (this.inGroup()) {
            this.getCurrentStepGroup().addChildStep(step);
            this.renumberTestSteps();
        } else {
            this.addStep(step);
        }
        return this;
    }

    private void addStep(TestStep step) {
        this.testSteps.add(step);
        this.renumberTestSteps();
    }

    private void addSteps(List<TestStep> steps) {
        this.testSteps.addAll(steps);
        this.renumberTestSteps();
    }

    private void renumberTestSteps() {
        int count = 1;
        for (TestStep step : this.testSteps) {
            count = step.renumberFrom(count);
        }
    }

    private TestStep getCurrentStepGroup() {
        return this.groupStack.peek();
    }

    private boolean inGroup() {
        return !this.groupStack.empty();
    }

    public ApplicationFeature getFeature() {
        if (this.getUserStory() != null && this.getUserStory().getFeature() != null) {
            return this.getUserStory().getFeature();
        }
        return null;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    private List<TestResult> getCurrentTestResults() {
        return Lambda.convert(this.testSteps, (Converter)new ExtractTestResultsConverter());
    }

    @Deprecated
    public void startGroup(String groupName) {
        this.recordStep(new TestStep(groupName));
        this.startGroup();
    }

    public Optional<String> getQualifier() {
        return this.qualifier;
    }

    public void startGroup() {
        if (!this.testSteps.isEmpty()) {
            this.groupStack.push(this.getCurrentStep());
        }
    }

    public void endGroup() {
        if (!this.groupStack.isEmpty()) {
            this.groupStack.pop();
        }
    }

    public TestStep getCurrentStep() {
        Preconditions.checkState((!this.testSteps.isEmpty() ? 1 : 0) != 0);
        if (!this.inGroup()) {
            return this.lastStepIn(this.testSteps);
        }
        TestStep currentStepGroup = this.groupStack.peek();
        return this.lastStepIn(currentStepGroup.getChildren());
    }

    public TestStep getLastStep() {
        Preconditions.checkState((!this.testSteps.isEmpty() ? 1 : 0) != 0);
        if (!this.inGroup()) {
            return this.lastStepIn(this.testSteps);
        }
        TestStep currentStepGroup = this.groupStack.peek();
        return this.lastStepIn(currentStepGroup.getChildren());
    }

    private TestStep lastStepIn(List<TestStep> testSteps) {
        return testSteps.get(testSteps.size() - 1);
    }

    public TestStep getCurrentGroup() {
        Preconditions.checkState((boolean)this.inGroup());
        return this.groupStack.peek();
    }

    public void setUserStory(Story story) {
        this.userStory = story;
    }

    public void setTestFailureCause(Throwable cause) {
        this.testFailureCause = cause;
    }

    public Throwable getTestFailureCause() {
        return this.testFailureCause;
    }

    public void setAnnotatedResult(TestResult annotatedResult) {
        if (this.annotatedResult != TestResult.PENDING) {
            this.annotatedResult = annotatedResult;
        }
    }

    private List<String> issues() {
        if (!this.thereAre(this.issues)) {
            this.issues = this.removeDuplicates(this.readIssues());
        }
        return this.issues;
    }

    public List<String> getIssues() {
        ArrayList<String> allIssues = new ArrayList<String>(this.issues());
        if (this.thereAre(this.additionalIssues)) {
            allIssues.addAll(this.additionalIssues);
        }
        return ImmutableList.copyOf(allIssues);
    }

    private List<String> versions() {
        if (!this.thereAre(this.versions)) {
            this.versions = this.removeDuplicates(this.readVersions());
        }
        return this.versions;
    }

    private List<String> readVersions() {
        return TestOutcomeAnnotationReader.forTestOutcome(this).readVersions();
    }

    public List<String> getVersions() {
        ArrayList<String> allVersions = new ArrayList<String>(this.versions());
        if (this.thereAre(this.additionalVersions)) {
            allVersions.addAll(this.additionalVersions);
        }
        this.addVersionsDefinedInTagsTo(allVersions);
        return ImmutableList.copyOf(allVersions);
    }

    private void addVersionsDefinedInTagsTo(List<String> allVersions) {
        for (TestTag tag : this.getTags()) {
            if (!tag.getType().equalsIgnoreCase("version") || allVersions.contains(tag.getName())) continue;
            allVersions.add(tag.getName());
        }
    }

    public Class<?> getTestCase() {
        return this.testCase;
    }

    private boolean thereAre(Collection<String> anyIssues) {
        return anyIssues != null && !anyIssues.isEmpty();
    }

    public TestOutcome addVersion(String version) {
        if (!this.getVersions().contains(version)) {
            this.additionalVersions.add(version);
        }
        return this;
    }

    public TestOutcome addVersions(List<String> versions) {
        for (String version : versions) {
            this.addVersion(version);
        }
        return this;
    }

    public TestOutcome forProject(String project) {
        this.project = project;
        return this;
    }

    public String getProject() {
        return this.project;
    }

    public TestOutcome inTestRunTimestamped(DateTime testRunTimestamp) {
        this.setTestRunTimestamp(testRunTimestamp);
        return this;
    }

    public void setTestRunTimestamp(DateTime testRunTimestamp) {
        this.testRunTimestamp = testRunTimestamp.getMillis();
    }

    public void addIssues(List<String> issues) {
        this.additionalIssues.addAll(issues);
    }

    private List<String> readIssues() {
        return TestOutcomeAnnotationReader.forTestOutcome(this).readIssues();
    }

    public String getFormattedIssues() {
        List<String> issues = this.getIssues();
        if (!issues.isEmpty()) {
            List orderedIssues = Lambda.sort(this.getIssues(), (Object)Lambda.on(String.class));
            return "(" + this.getFormatter().addLinks(StringUtils.join((Iterable)orderedIssues, (String)", ")) + ")";
        }
        return "";
    }

    public void isRelatedToIssue(String issue) {
        if (!this.issues().contains(issue)) {
            this.issues().add(issue);
        }
    }

    public void addFailingExternalStep(Throwable testFailureCause) {
        this.addFailingStepAsSibling(this.testSteps, testFailureCause);
    }

    public void addFailingStepAsSibling(List<TestStep> testStepList, Throwable testFailureCause) {
        if (testStepList.isEmpty()) {
            this.addStep(this.failingStep(testFailureCause));
        } else {
            TestStep lastStep = this.lastStepIn(testStepList);
            if (lastStep.hasChildren()) {
                this.addFailingStepAsSibling(lastStep.children(), testFailureCause);
            } else {
                testStepList.add(this.failingStep(testFailureCause));
            }
        }
    }

    private TestStep failingStep(Throwable testFailureCause) {
        TestStep failingStep = new TestStep("Failure");
        failingStep.failedWith(testFailureCause);
        return failingStep;
    }

    public void lastStepFailedWith(StepFailure failure) {
        this.lastStepFailedWith(failure.getException());
    }

    public void lastStepFailedWith(Throwable testFailureCause) {
        this.setTestFailureCause(testFailureCause);
        TestStep lastTestStep = this.testSteps.get(this.testSteps.size() - 1);
        lastTestStep.failedWith(new StepFailureException(testFailureCause.getMessage(), testFailureCause));
    }

    public Set<TestTag> getTags() {
        if (this.tags == null) {
            this.tags = this.getTagsUsingTagProviders(this.getTagProviderService().getTagProviders());
        }
        return ImmutableSet.copyOf(this.tags);
    }

    private Set<TestTag> getTagsUsingTagProviders(List<TagProvider> tagProviders) {
        HashSet tags = Sets.newHashSet();
        for (TagProvider tagProvider : tagProviders) {
            try {
                Set<TestTag> providedTags = tagProvider.getTagsFor(this);
                if (providedTags == null) continue;
                tags.addAll(providedTags);
            }
            catch (Throwable theTagProviderFailedBueThereIsntMuchWeCanDoAboutIt) {
                this.logger.error("Tag provider " + tagProvider + " failure", theTagProviderFailedBueThereIsntMuchWeCanDoAboutIt);
            }
        }
        return tags;
    }

    public void setTags(Set<TestTag> tags) {
        this.tags = Sets.newHashSet(tags);
    }

    public void addTags(List<TestTag> tags) {
        this.getTags();
        this.tags.addAll(tags);
    }

    public List<String> getIssueKeys() {
        return Lambda.convert(this.getIssues(), this.toIssueKeys());
    }

    private Converter<String, String> toIssueKeys() {
        return new Converter<String, String>(){

            public String convert(String issueNumber) {
                String issueKey = issueNumber;
                if (issueKey.startsWith("#")) {
                    issueKey = issueKey.substring(1);
                }
                if (StringUtils.isNumeric((CharSequence)issueKey) && TestOutcome.this.getProjectPrefix() != null) {
                    Joiner joiner = Joiner.on((String)"-");
                    issueKey = joiner.join((Object)TestOutcome.this.getProjectPrefix(), (Object)issueKey, new Object[0]);
                }
                return issueKey;
            }
        };
    }

    private String getProjectPrefix() {
        return ThucydidesSystemProperty.THUCYDIDES_PROJECT_KEY.from(this.getEnvironmentVariables());
    }

    public String getQualifiedMethodName() {
        if (this.qualifier != null && this.qualifier.isPresent()) {
            String qualifierWithoutSpaces = ((String)this.qualifier.get()).replaceAll(" ", "_");
            return String.valueOf(this.getMethodName()) + "_" + qualifierWithoutSpaces;
        }
        return this.getMethodName();
    }

    public String getCompleteName() {
        if (StringUtils.isNotEmpty((CharSequence)this.getStoryTitle())) {
            return String.valueOf(this.getStoryTitle()) + ":" + this.getMethodName();
        }
        return this.getTestCase() + ":" + this.getMethodName();
    }

    public void useExamplesFrom(DataTable table) {
        this.dataTable = table;
    }

    public void moveToNextRow() {
        if (this.dataTable != null && !this.dataTable.atLastRow()) {
            this.dataTable.nextRow();
        }
    }

    public void updateCurrentRowResult(TestResult result) {
        this.dataTable.currentRow().hasResult(result);
    }

    public boolean dataIsPredefined() {
        return this.dataTable.hasPredefinedRows();
    }

    public void addRow(Map<String, ?> data) {
        this.dataTable.addRow(data);
    }

    public void addRow(DataTableRow dataTableRow) {
        this.dataTable.addRow(dataTableRow);
    }

    public int getTestCount() {
        return this.isDataDriven() ? this.getDataTable().getSize() : 1;
    }

    public int getImplementedTestCount() {
        return this.getStepCount() > 0 ? this.getTestCount() : 0;
    }

    public int countResults(TestResult expectedResult) {
        return this.countResults(expectedResult, TestType.ANY);
    }

    public int countResults(TestResult expectedResult, TestType expectedType) {
        if (this.isDataDriven()) {
            return this.countDataRowsWithResult(expectedResult);
        }
        return this.getResult() == expectedResult && this.typeCompatibleWith(expectedType) ? 1 : 0;
    }

    public boolean typeCompatibleWith(TestType testType) {
        switch (testType) {
            case MANUAL: {
                return this.isManual();
            }
            case AUTOMATED: {
                return !this.isManual();
            }
        }
        return true;
    }

    private int countDataRowsWithResult(TestResult expectedResult) {
        List matchingRows = Lambda.filter((Matcher)Lambda.having((Object)((Object)((DataTableRow)Lambda.on(DataTableRow.class)).getResult()), (Matcher)Matchers.is((Object)((Object)expectedResult))), this.getDataTable().getRows());
        return matchingRows.size();
    }

    public int countNestedStepsWithResult(TestResult expectedResult, TestType testType) {
        if (this.isDataDriven()) {
            return this.countDataRowStepsWithResult(expectedResult);
        }
        return this.getResult() == expectedResult && this.typeCompatibleWith(testType) ? this.getNestedStepCount() : 0;
    }

    private int countDataRowStepsWithResult(TestResult expectedResult) {
        int rowsWithResult = this.countDataRowsWithResult(expectedResult);
        int totalRows = this.getDataTable().getSize();
        int totalSteps = this.getNestedStepCount();
        return totalSteps * rowsWithResult / totalRows;
    }

    public Optional<String> getTagValue(String tagType) {
        if (tagType.equalsIgnoreCase(ISSUES) && !this.getIssueKeys().isEmpty()) {
            return Optional.of((Object)Joiner.on((String)",").join(this.getIssueKeys()));
        }
        for (TestTag tag : this.getTags()) {
            if (!tag.getType().equalsIgnoreCase(tagType)) continue;
            return Optional.of((Object)tag.getName());
        }
        return Optional.absent();
    }

    public boolean hasIssue(String issue) {
        return this.getIssues().contains(issue);
    }

    public boolean hasTag(TestTag tag) {
        return this.getTags().contains(tag);
    }

    public void setStartTime(DateTime startTime) {
        this.startTime = startTime.getMillis();
    }

    public void clearStartTime() {
        this.startTime = 0L;
    }

    public boolean isManual() {
        return this.manualTest;
    }

    public boolean isStartTimeNotDefined() {
        return this.startTime == 0L;
    }

    private SystemClock getSystemClock() {
        return (SystemClock)Injectors.getInjector().getInstance(SystemClock.class);
    }

    private long now() {
        return this.getSystemClock().getCurrentTime().getMillis();
    }

    public Integer getStepCount() {
        return this.testSteps.size();
    }

    public Integer getNestedStepCount() {
        return this.getFlattenedTestSteps().size();
    }

    public Integer getSuccessCount() {
        return this.count(this.successfulSteps()).in(this.getLeafTestSteps());
    }

    public Integer getFailureCount() {
        return this.count(this.failingSteps()).in(this.getLeafTestSteps());
    }

    public Integer getErrorCount() {
        return this.count(this.errorSteps()).in(this.getLeafTestSteps());
    }

    public Integer getIgnoredCount() {
        return this.count(this.ignoredSteps()).in(this.getLeafTestSteps());
    }

    public Integer getSkippedOrIgnoredCount() {
        return this.getIgnoredCount() + this.getSkippedCount();
    }

    public Integer getSkippedCount() {
        return this.count(this.skippedSteps()).in(this.getLeafTestSteps());
    }

    public Integer getPendingCount() {
        List<TestStep> allTestSteps = this.getLeafTestSteps();
        return Lambda.select(allTestSteps, (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).isPending())).size();
    }

    public Boolean isSuccess() {
        if (this.getResult() == TestResult.SUCCESS) {
            return true;
        }
        return false;
    }

    public Boolean isFailure() {
        if (this.getResult() == TestResult.FAILURE) {
            return true;
        }
        return false;
    }

    public Boolean isError() {
        if (this.getResult() == TestResult.ERROR) {
            return true;
        }
        return false;
    }

    public Boolean isPending() {
        if (this.getResult() == TestResult.PENDING) {
            return true;
        }
        return false;
    }

    public Boolean isSkipped() {
        if (this.getResult() != TestResult.SKIPPED && this.getResult() != TestResult.IGNORED) {
            return false;
        }
        return true;
    }

    public Story getUserStory() {
        return this.userStory;
    }

    public void recordDuration() {
        this.setDuration(System.currentTimeMillis() - this.startTime);
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public Long getDuration() {
        if (this.duration == 0L && this.testSteps.size() > 0) {
            return (Long)Lambda.sum(this.testSteps, (Object)((TestStep)Lambda.on(TestStep.class)).getDuration());
        }
        return this.duration;
    }

    public double getDurationInSeconds() {
        return TestDuration.of(this.duration).inSeconds();
    }

    public String getVideoLink() {
        return this.linkGenerator.linkFor(this);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    StepCountBuilder count(StepFilter filter) {
        return new StepCountBuilder(filter);
    }

    public Integer countTestSteps() {
        return this.countLeafStepsIn(this.testSteps);
    }

    private Integer countLeafStepsIn(List<TestStep> testSteps) {
        int leafCount = 0;
        for (TestStep step : testSteps) {
            if (step.isAGroup()) {
                leafCount += this.countLeafStepsIn(step.getChildren()).intValue();
                continue;
            }
            ++leafCount;
        }
        return leafCount;
    }

    StepFilter successfulSteps() {
        return new StepFilter(this){

            @Override
            boolean apply(TestStep step) {
                return step.isSuccessful();
            }
        };
    }

    StepFilter failingSteps() {
        return new StepFilter(this){

            @Override
            boolean apply(TestStep step) {
                return step.isFailure();
            }
        };
    }

    StepFilter errorSteps() {
        return new StepFilter(this){

            @Override
            boolean apply(TestStep step) {
                return step.isError();
            }
        };
    }

    StepFilter ignoredSteps() {
        return new StepFilter(this){

            @Override
            boolean apply(TestStep step) {
                return step.isIgnored();
            }
        };
    }

    StepFilter skippedSteps() {
        return new StepFilter(this){

            @Override
            boolean apply(TestStep step) {
                return step.isSkipped();
            }
        };
    }

    public void setStatistics(TestStatistics statistics) {
        this.statistics = statistics;
    }

    public TestStatistics getStatistics() {
        return this.statistics;
    }

    public double getOverallStability() {
        if (this.getStatistics() == null) {
            return 0.0;
        }
        return this.getStatistics().getOverallPassRate();
    }

    public double getRecentStability() {
        if (this.getStatistics() == null) {
            return 0.0;
        }
        return this.getStatistics().getPassRate().overTheLast(10).testRuns();
    }

    public Long getRecentTestRunCount() {
        if (this.getStatistics() == null) {
            return 0L;
        }
        return this.getStatistics().getTotalTestRuns() > 10L ? 10L : this.getStatistics().getTotalTestRuns();
    }

    public int getRecentPassCount() {
        if (this.getStatistics() == null) {
            return 0;
        }
        return this.getStatistics().countResults().overTheLast(10).whereTheOutcomeWas(TestResult.SUCCESS);
    }

    public int getRecentFailCount() {
        if (this.getStatistics() == null) {
            return 0;
        }
        return this.getStatistics().countResults().overTheLast(10).whereTheOutcomeWas(TestResult.FAILURE);
    }

    public int getRecentPendingCount() {
        if (this.getStatistics() == null) {
            return 0;
        }
        return this.getStatistics().countResults().overTheLast(10).whereTheOutcomeWas(TestResult.PENDING);
    }

    public DateTime getStartTime() {
        return new DateTime(this.startTime);
    }

    public Optional<DateTime> getTestRunTimestamp() {
        return this.testRunTimestamp != 0L ? Optional.of((Object)new DateTime(this.testRunTimestamp)) : this.NO_BATCH_START_TIME;
    }

    public boolean isDataDriven() {
        return this.dataTable != null;
    }

    public List<String> getExampleFields() {
        return this.isDataDriven() ? this.getDataTable().getHeaders() : this.NO_HEADERS;
    }

    public String getDataDrivenSampleScenario() {
        if (!this.isDataDriven() || this.getTestSteps().isEmpty() || !this.getTestSteps().get(0).hasChildren()) {
            return "";
        }
        TestStep firstExample = this.getTestSteps().get(0);
        StringBuilder sampleScenario = new StringBuilder();
        for (TestStep topLevelChildStep : firstExample.getChildren()) {
            sampleScenario.append(topLevelChildStep.getDescription());
            if (topLevelChildStep == this.lastOf(firstExample.getChildren())) continue;
            sampleScenario.append("\n");
        }
        return sampleScenario.toString();
    }

    private TestStep lastOf(List<TestStep> children) {
        return children.get(children.size() - 1);
    }

    public DataTable getDataTable() {
        return this.dataTable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestOutcome that = (TestOutcome)o;
        if (this.manualTest != that.manualTest) {
            return false;
        }
        if (this.methodName != null ? !this.methodName.equals(that.methodName) : that.methodName != null) {
            return false;
        }
        if (this.qualifier != null ? !this.qualifier.equals(that.qualifier) : that.qualifier != null) {
            return false;
        }
        if (this.testCase != null ? !this.testCase.equals(that.testCase) : that.testCase != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        return !(this.userStory != null ? !this.userStory.equals(that.userStory) : that.userStory != null);
    }

    public int hashCode() {
        int result = this.methodName != null ? this.methodName.hashCode() : 0;
        result = 31 * result + (this.testCase != null ? this.testCase.hashCode() : 0);
        result = 31 * result + (this.userStory != null ? this.userStory.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.qualifier != null ? this.qualifier.hashCode() : 0);
        result = 31 * result + (this.manualTest ? 1 : 0);
        return result;
    }

    private static class ExtractTestResultsConverter
    implements Converter<TestStep, TestResult> {
        private ExtractTestResultsConverter() {
        }

        public TestResult convert(TestStep step) {
            return step.getResult();
        }
    }

    public static class StepCountBuilder {
        private final StepFilter filter;

        public StepCountBuilder(StepFilter filter) {
            this.filter = filter;
        }

        int in(List<TestStep> steps) {
            int count = 0;
            for (TestStep step : steps) {
                if (!this.filter.apply(step)) continue;
                ++count;
            }
            return count;
        }
    }

    abstract class StepFilter {
        StepFilter() {
        }

        abstract boolean apply(TestStep var1);
    }
}

