/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import com.beust.jcommander.internal.Lists;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.Narrative;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reflection.ClassFinder;
import net.thucydides.core.requirements.AbstractRequirementsTagProvider;
import net.thucydides.core.requirements.OverridableTagProvider;
import net.thucydides.core.requirements.RequirementPersister;
import net.thucydides.core.requirements.RequirementsTagProvider;
import net.thucydides.core.requirements.annotations.NarrativeFinder;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.SystemPropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;

public class PackageAnnotationBasedTagProvider
extends AbstractRequirementsTagProvider
implements RequirementsTagProvider,
OverridableTagProvider {
    private static final String DOT_REGEX = "\\.";
    private static final List<String> SUPPORTED_SUFFIXES = ImmutableList.of((Object)"story", (Object)"feature");
    private List<Requirement> requirements;
    private final Configuration configuration;
    private final RequirementPersister persister;
    private final String rootPackage;
    private List<Requirement> leafRequirements;
    SortedMap<String, Requirement> requirementsByPath = Maps.newTreeMap();
    Map<Requirement, String> requirementPaths = Maps.newHashMap();

    public PackageAnnotationBasedTagProvider() {
        this((EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    public PackageAnnotationBasedTagProvider(EnvironmentVariables vars) {
        super(vars);
        this.configuration = new SystemPropertiesConfiguration(this.environmentVariables);
        this.rootPackage = ThucydidesSystemProperty.THUCYDIDES_TEST_ROOT.from(this.environmentVariables, this.rootDirectory);
        this.persister = new RequirementPersister(this.configuration.getOutputDirectory(), this.rootPackage);
        this.leafRequirements = Lists.newArrayList();
    }

    private Collection<Requirement> getAllRequirements() {
        return this.getRequirementsByPath().values();
    }

    @Override
    public Set<TestTag> getTagsFor(TestOutcome testOutcome) {
        HashSet<TestTag> result = new HashSet<TestTag>();
        for (Requirement requirement : this.getAllRequirements()) {
            if (!this.isMatchingRequirementFor(testOutcome, requirement)) continue;
            result.add(TestTag.withName(this.humanReadableVersionOf(requirement.getName())).andType(requirement.getType()));
        }
        return result;
    }

    private boolean isMatchingRequirementFor(TestOutcome testOutcome, Requirement requirement) {
        return this.fullPathOf(requirement).matchesOrIsADescendantOf(this.normalizedPath(testOutcome.getPathId())) || this.fullPathOf(requirement).matchesOrIsADescendantOf(this.normalizedPath(testOutcome.getPath()));
    }

    private String normalizedPath(String path) {
        path = path.replaceAll("/", ".");
        for (String supportedSuffix : SUPPORTED_SUFFIXES) {
            if (!path.endsWith("." + supportedSuffix)) continue;
            path = path.substring(0, path.lastIndexOf("." + supportedSuffix));
        }
        if (!path.startsWith(this.rootPackage)) {
            path = String.valueOf(this.rootPackage) + "." + path;
        }
        return path;
    }

    private RequirementPathMatcher fullPathOf(Requirement requirement) {
        return new RequirementPathMatcher(requirement);
    }

    @Override
    public List<Requirement> getRequirements() {
        if (this.requirements == null) {
            this.requirements = this.loadRequirements();
        }
        return this.requirements;
    }

    private List<Requirement> loadRequirements() {
        List<Class<?>> classes = this.loadClasses();
        if (classes.isEmpty()) {
            this.requirementsByPath = this.loadFromJSON();
        } else {
            this.loadRequirementsFromClasses(classes);
        }
        this.requirementPaths = this.indexRequirements(this.requirementsByPath);
        List<Requirement> requirementsTree = this.buildRequirementsTree(this.requirementsByPath, this.requirementPaths);
        return ImmutableList.copyOf(requirementsTree);
    }

    protected List<Class<?>> loadClasses() {
        return ClassFinder.loadClasses().annotatedWith(Narrative.class).fromPackage(this.rootPackage);
    }

    private SortedMap<String, Requirement> loadFromJSON() {
        try {
            return this.persister.read();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new TreeMap<String, Requirement>();
        }
    }

    private Map<Requirement, String> indexRequirements(SortedMap<String, Requirement> requirementsByPath) {
        HashMap requirementPaths = Maps.newHashMap();
        for (String path : requirementsByPath.keySet()) {
            Requirement requirement = (Requirement)requirementsByPath.get(path);
            requirementPaths.put(requirement, path);
        }
        return requirementPaths;
    }

    private void loadRequirementsFromClasses(List<Class<?>> classes) {
        for (Class<?> candidateClass : classes) {
            this.addRequirementTo(this.requirementsByPath, candidateClass);
        }
        this.leafRequirements = this.findLeafRequirementsIn(this.requirementsByPath);
        this.persistRequirementsAsJSON(this.requirementsByPath);
    }

    private void persistRequirementsAsJSON(SortedMap<String, Requirement> requirementsByPath) {
        try {
            this.persister.write(requirementsByPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private List<Requirement> buildRequirementsTree(SortedMap<String, Requirement> requirementsByPath, Map<Requirement, String> requirementPaths) {
        List requirementsTree = Lists.newArrayList();
        for (Requirement requirement : requirementsByPath.values()) {
            if (!this.isRoot(requirementPaths.get(requirement))) continue;
            List<Requirement> children = this.findDirectChildrenFor(requirement, requirementsByPath, requirementPaths);
            requirementsTree.add(requirement.withChildren(children));
        }
        return requirementsTree;
    }

    private boolean isRoot(String path) {
        return !path.contains(".");
    }

    private List<Requirement> findDirectChildrenFor(Requirement requirement, SortedMap<String, Requirement> requirementsByPath, Map<Requirement, String> requirementPaths) {
        List immediateChildren = Lists.newArrayList();
        if (!this.isLeaf(requirement)) {
            String requirementPath = requirementPaths.get(requirement);
            for (String path : requirementsByPath.keySet()) {
                Requirement childRequirement = (Requirement)requirementsByPath.get(path);
                if (childRequirement == requirement || !this.isImmediateChild(requirementPath, path)) continue;
                if (this.isLeaf(childRequirement)) {
                    immediateChildren.add(childRequirement);
                    continue;
                }
                immediateChildren.add(childRequirement.withChildren(this.findDirectChildrenFor(childRequirement, requirementsByPath, requirementPaths)));
            }
        }
        return immediateChildren;
    }

    private boolean isLeaf(Requirement childRequirement) {
        return this.leafRequirements.contains(childRequirement);
    }

    private boolean isImmediateChild(String requirementPath, String path) {
        if (path.startsWith(requirementPath)) {
            String trailingPath = path.replaceFirst(String.valueOf(requirementPath) + ".", "");
            return !StringUtils.isEmpty((CharSequence)trailingPath) && !trailingPath.contains(".");
        }
        return false;
    }

    private String getFullRequirementPath(Class candidateClass) {
        return candidateClass.getName().replace(String.valueOf(this.rootPackage) + ".", "").replace(".package-info", "");
    }

    private void addRequirementTo(SortedMap<String, Requirement> requirementsByPath, Class candidateClass) {
        String fullRequirementName = this.getFullRequirementPath(candidateClass);
        String[] packageNames = fullRequirementName.split(DOT_REGEX);
        String currentPath = "";
        int level = 0;
        while (level < packageNames.length) {
            currentPath = currentPath.isEmpty() ? packageNames[level] : Joiner.on((String)".").join((Object)currentPath, (Object)packageNames[level], new Object[0]);
            String defaultRequirementType = this.getDefaultType(level);
            if (!requirementsByPath.containsKey(currentPath)) {
                Requirement currentRequirement;
                if (level < packageNames.length - 1) {
                    currentRequirement = this.newParentRequirement(currentPath, packageNames[level], level, defaultRequirementType);
                    requirementsByPath.put(currentPath, currentRequirement);
                } else {
                    currentRequirement = this.newRequirement(candidateClass, currentPath, packageNames[level], level, defaultRequirementType);
                    String fullPath = this.getFullRequirementPath(candidateClass);
                    requirementsByPath.put(fullPath, currentRequirement);
                }
            }
            ++level;
        }
    }

    private List<Requirement> findLeafRequirementsIn(Map<String, Requirement> requirementsByPath) {
        List leafRequirements = Lists.newArrayList();
        for (String path : requirementsByPath.keySet()) {
            if (this.longerPathExists(path, requirementsByPath.keySet())) continue;
            leafRequirements.add(requirementsByPath.get(path));
        }
        return leafRequirements;
    }

    private boolean longerPathExists(String path, Set<String> paths) {
        for (String requirementPath : paths) {
            if (!requirementPath.startsWith(path) || requirementPath.length() <= path.length()) continue;
            return true;
        }
        return false;
    }

    private Requirement newParentRequirement(String requirementPath, String packageName, int level, String defaultRequirementType) {
        String requirementTitle = packageName;
        String requirementType = defaultRequirementType;
        String narrativeText = "";
        String cardNumber = "";
        Class<?> candidateClass = null;
        Optional<Narrative> narrative = Optional.absent();
        try {
            candidateClass = Class.forName(String.valueOf(this.rootPackage) + "." + requirementPath + ".package-info");
            narrative = NarrativeFinder.forClass(candidateClass);
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return this.getRequirement(candidateClass, packageName, level, requirementTitle, requirementType, narrativeText, cardNumber, narrative);
    }

    private Requirement newRequirement(Class candidateClass, String currentPath, String packageName, int level, String defaultRequirementType) {
        String requirementTitle = packageName;
        String requirementType = defaultRequirementType;
        String narrativeText = "";
        String cardNumber = "";
        Optional<Narrative> narrative = NarrativeFinder.forClass(candidateClass);
        return this.getRequirement(candidateClass, packageName, level, requirementTitle, requirementType, narrativeText, cardNumber, narrative);
    }

    private Requirement getRequirement(Class candidateClass, String packageName, int level, String requirementTitle, String requirementType, String narrativeText, String cardNumber, Optional<Narrative> narrative) {
        if (narrative.isPresent()) {
            requirementTitle = ((Narrative)narrative.get()).title();
            requirementType = ((Narrative)narrative.get()).type();
            narrativeText = Joiner.on((String)"\n").join((Object[])((Narrative)narrative.get()).text());
            cardNumber = ((Narrative)narrative.get()).cardNumber();
        }
        if (StringUtils.isEmpty((CharSequence)requirementType)) {
            requirementType = this.getRequirementType(level, candidateClass);
        }
        return Requirement.named(this.humanReadableVersionOf(packageName)).withOptionalCardNumber(cardNumber).withOptionalDisplayName(StringUtils.isEmpty((CharSequence)requirementTitle) ? this.humanReadableVersionOf(packageName) : requirementTitle).withType(requirementType).withNarrative(narrativeText);
    }

    private String getRequirementType(int level, Class candidateClass) {
        if (candidateClass != null && candidateClass.getName().endsWith(".package-info")) {
            return this.getDefaultType(level);
        }
        return "story";
    }

    @Override
    public Optional<Requirement> getParentRequirementOf(TestOutcome testOutcome) {
        if (testOutcome.getUserStory() == null || testOutcome.getUserStory().getUserStoryClass() == null || testOutcome.getUserStory().getUserStoryClass().getName() == null) {
            return Optional.absent();
        }
        String name = testOutcome.getUserStory().getUserStoryClass().getName().replace(String.valueOf(this.rootPackage) + ".", "");
        return Optional.fromNullable((Object)((Requirement)this.getRequirementsByPath().get(name)));
    }

    @Override
    public Optional<Requirement> getRequirementFor(TestTag testTag) {
        Optional result = Optional.absent();
        for (Requirement requirement : this.getRequirements()) {
            if (!requirement.asTag().equals(testTag)) continue;
            return Optional.of((Object)requirement);
        }
        return result;
    }

    public SortedMap<String, Requirement> getRequirementsByPath() {
        this.getRequirements();
        return this.requirementsByPath;
    }

    private class RequirementPathMatcher {
        String requirementPath;

        public RequirementPathMatcher(Requirement requirement) {
            this.requirementPath = String.valueOf(PackageAnnotationBasedTagProvider.this.rootPackage) + "." + PackageAnnotationBasedTagProvider.this.requirementPaths.get(requirement);
        }

        public boolean matchesOrIsADescendantOf(String path) {
            if (StringUtils.isNotEmpty((CharSequence)path)) {
                return path.startsWith(this.requirementPath) || this.requirementPath.startsWith(path);
            }
            return false;
        }
    }
}

