/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import net.thucydides.core.Thucydides;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.logging.LoggingLevel;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleLoggingListener
implements StepListener {
    private static final List<String> BANNER_HEADINGS = ImmutableList.of((Object)"\n--------------\n- THUCYDIDES -\n--------------", (Object)"\n\n-------------------------------------------------------------------------------------------------------\n.___________. __    __   __    __    ______ ____    ____  _______   __   _______   _______     _______.\n|           ||  |  |  | |  |  |  |  /      |\\   \\  /   / |       \\ |  | |       \\ |   ____|   /       |\n`---|  |----`|  |__|  | |  |  |  | |  ,----' \\   \\/   /  |  .--.  ||  | |  .--.  ||  |__     |   (----`\n    |  |     |   __   | |  |  |  | |  |       \\_    _/   |  |  |  ||  | |  |  |  ||   __|     \\   \\    \n    |  |     |  |  |  | |  `--'  | |  `----.    |  |     |  '--'  ||  | |  '--'  ||  |____.----)   |   \n    |__|     |__|  |__|  \\______/   \\______|    |__|     |_______/ |__| |_______/ |_______|_______/    \n                                                                                                       \n-------------------------------------------------------------------------------------------------------\n");
    private static final List<String> TEST_STARTED_HEADINGS = ImmutableList.of((Object)"\n----------------\n- TEST STARTED -\n----------------", (Object)"\n  _____ _____ ____ _____   ____ _____  _    ____ _____ _____ ____  \n |_   _| ____/ ___|_   _| / ___|_   _|/ \\  |  _ \\_   _| ____|  _ \\ \n   | | |  _| \\___ \\ | |   \\___ \\ | | / _ \\ | |_) || | |  _| | | | |\n   | | | |___ ___) || |    ___) || |/ ___ \\|  _ < | | | |___| |_| |\n   |_| |_____|____/ |_|   |____/ |_/_/   \\_\\_| \\_\\|_| |_____|____/ \n                                                                   \n");
    private static final List<String> TEST_PASSED_HEADINGS = ImmutableList.of((Object)"\n---------------\n- TEST PASSED -\n---------------", (Object)"\n        __    _____ _____ ____ _____   ____   _    ____  ____  _____ ____  \n  _     \\ \\  |_   _| ____/ ___|_   _| |  _ \\ / \\  / ___|/ ___|| ____|  _ \\ \n (_)_____| |   | | |  _| \\___ \\ | |   | |_) / _ \\ \\___ \\\\___ \\|  _| | | | |\n  _|_____| |   | | | |___ ___) || |   |  __/ ___ \\ ___) |___) | |___| |_| |\n (_)     | |   |_| |_____|____/ |_|   |_| /_/   \\_\\____/|____/|_____|____/ \n        /_/                                                                \n");
    private static final List<String> TEST_FAILED_HEADINGS = ImmutableList.of((Object)"\n----------------\n- TEST FAILED -\n----------------", (Object)"\n           __  _____ _____ ____ _____   _____ _    ___ _     _____ ____  \n  _       / / |_   _| ____/ ___|_   _| |  ___/ \\  |_ _| |   | ____|  _ \\ \n (_)_____| |    | | |  _| \\___ \\ | |   | |_ / _ \\  | || |   |  _| | | | |\n  _|_____| |    | | | |___ ___) || |   |  _/ ___ \\ | || |___| |___| |_| |\n (_)     | |    |_| |_____|____/ |_|   |_|/_/   \\_\\___|_____|_____|____/ \n          \\_\\                                                            \n");
    private static final List<String> TEST_SKIPPED_HEADINGS = ImmutableList.of((Object)"\n----------------\n- TEST SKIPPED -\n----------------", (Object)"\n            __  _____ _____ ____ _____   ____  _  _____ ____  ____  _____ ____  \n  _        / / |_   _| ____/ ___|_   _| / ___|| |/ /_ _|  _ \\|  _ \\| ____|  _ \\ \n (_)_____ / /    | | |  _| \\___ \\ | |   \\___ \\| ' / | || |_) | |_) |  _| | | | |\n  _|_____/ /     | | | |___ ___) || |    ___) | . \\ | ||  __/|  __/| |___| |_| |\n (_)    /_/      |_| |_____|____/ |_|   |____/|_|\\_\\___|_|   |_|   |_____|____/ \n                                                                                \n");
    private static List<String> FAILURE_HEADINGS = ImmutableList.of((Object)"\n-----------\n- FAILURE -\n-----------", (Object)"\n  _____ _    ___ _     _   _ ____  _____ \n |  ___/ \\  |_ _| |   | | | |  _ \\| ____|\n | |_ / _ \\  | || |   | | | | |_) |  _|  \n |  _/ ___ \\ | || |___| |_| |  _ <| |___ \n |_|/_/   \\_\\___|_____|\\___/|_| \\_\\_____|\n                                         \n");
    private final Logger logger;
    private final EnvironmentVariables environmentVariables;
    private final int headingStyle;

    public ConsoleLoggingListener(EnvironmentVariables environmentVariables, Logger logger) {
        this.logger = logger;
        this.environmentVariables = environmentVariables;
        String headerStyleValue = environmentVariables.getProperty(ThucydidesSystemProperty.THUCYDIDES_CONSOLE_HEADINGS, HeadingStyle.ASCII.toString()).toUpperCase();
        this.headingStyle = HeadingStyle.NORMAL.toString().equals(headerStyleValue) ? 0 : 1;
        this.logBanner();
    }

    @Inject
    public ConsoleLoggingListener(EnvironmentVariables environmentVariables) {
        this(environmentVariables, LoggerFactory.getLogger(Thucydides.class));
    }

    protected Logger getLogger() {
        return this.logger;
    }

    private void logBanner() {
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info(this.bannerHeading());
        }
    }

    private String bannerHeading() {
        return BANNER_HEADINGS.get(this.headingStyle);
    }

    private boolean loggingLevelIsAtLeast(LoggingLevel minimumLoggingLevel) {
        return this.getLoggingLevel().compareTo(minimumLoggingLevel) >= 0;
    }

    private LoggingLevel getLoggingLevel() {
        String logLevel = ThucydidesSystemProperty.THUCYDIDES_LOGGING.from(this.environmentVariables, LoggingLevel.NORMAL.name());
        return LoggingLevel.valueOf(logLevel);
    }

    @Override
    public void testSuiteStarted(Class<?> storyClass) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info("Test Suite Started: " + NameConverter.humanize(storyClass.getSimpleName()));
        }
    }

    @Override
    public void testSuiteStarted(Story story) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info("Test Suite Started: " + NameConverter.humanize(story.getName()));
        }
    }

    @Override
    public void testSuiteFinished() {
    }

    @Override
    public void testStarted(String description) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info(String.valueOf(this.testStartedHeadings()) + "\nTEST STARTED: " + description + this.underline(TEST_STARTED_HEADINGS.get(this.headingStyle)));
        }
    }

    private String testStartedHeadings() {
        return TEST_STARTED_HEADINGS.get(this.headingStyle);
    }

    private String underline(String banner) {
        StringBuilder underline = new StringBuilder();
        int endOfLine = banner.indexOf(10, 1);
        if (endOfLine >= 0) {
            underline.append(StringUtils.repeat((char)'-', (int)endOfLine));
        } else {
            underline.append(StringUtils.repeat((char)'-', (int)banner.length()));
        }
        return "\n" + underline.toString();
    }

    @Override
    public void testFinished(TestOutcome result) {
        if (result.isFailure().booleanValue()) {
            this.logFailure(result);
        } else if (result.isPending().booleanValue()) {
            this.logPending(result);
        } else if (result.isSkipped().booleanValue()) {
            this.logSkipped(result);
        } else if (result.isSuccess().booleanValue()) {
            this.logSuccess(result);
        }
    }

    @Override
    public void testRetried() {
    }

    private void logFailure(TestOutcome result) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info(String.valueOf(this.testFailureHeading()) + "\nTEST FAILED: " + result.getTitle() + this.underline(TEST_FAILED_HEADINGS.get(this.headingStyle)));
            this.logRelatedIssues(result);
            this.logFailureCause(result);
            this.underline(FAILURE_HEADINGS.get(this.headingStyle));
        }
    }

    private String testFailureHeading() {
        return TEST_FAILED_HEADINGS.get(this.headingStyle);
    }

    private void logRelatedIssues(TestOutcome result) {
        Joiner joiner = Joiner.on((String)",");
        this.getLogger().info("RELATED ISSUES: " + joiner.join(result.getIssueKeys()));
    }

    private void logFailureCause(TestOutcome result) {
        if (result.getTestFailureCause() != null) {
            this.getLogger().info(String.valueOf(this.failureHeading()) + "\n" + result.getTestFailureCause().getMessage());
        }
    }

    private String failureHeading() {
        return FAILURE_HEADINGS.get(this.headingStyle);
    }

    private void logPending(TestOutcome result) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info(String.valueOf(this.testSkippedHeading()) + "\nTEST PENDING: " + result.getTitle() + this.underline(this.testSkippedHeading()));
        }
    }

    private String testSkippedHeading() {
        return TEST_SKIPPED_HEADINGS.get(this.headingStyle);
    }

    private void logSkipped(TestOutcome result) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info(String.valueOf(this.testSkippedHeading()) + "\nTEST SKIPPED: " + result.getTitle() + this.underline(this.testSkippedHeading()));
        }
    }

    private void logSuccess(TestOutcome result) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info(String.valueOf(this.testPassedHeading()) + "\nTEST PASSED: " + result.getTitle() + this.underline(this.testPassedHeading()));
        }
    }

    private String testPassedHeading() {
        return TEST_PASSED_HEADINGS.get(this.headingStyle);
    }

    @Override
    public void stepStarted(ExecutedStepDescription description) {
        this.getLoggingLevel();
        if (this.loggingLevelIsAtLeast(LoggingLevel.VERBOSE)) {
            this.getLogger().info("STARTING STEP " + description.getTitle());
        }
    }

    @Override
    public void skippedStepStarted(ExecutedStepDescription description) {
        this.stepStarted(description);
    }

    @Override
    public void stepFinished() {
        this.getLoggingLevel();
        if (this.loggingLevelIsAtLeast(LoggingLevel.VERBOSE)) {
            this.getLogger().info("FINISHING STEP");
        }
    }

    @Override
    public void stepFailed(StepFailure failure) {
        this.getLoggingLevel();
        if (this.loggingLevelIsAtLeast(LoggingLevel.VERBOSE)) {
            this.getLogger().info("STEP FAILED: " + failure.getMessage());
        }
    }

    @Override
    public void lastStepFailed(StepFailure failure) {
    }

    @Override
    public void stepIgnored() {
        this.getLoggingLevel();
        if (this.loggingLevelIsAtLeast(LoggingLevel.VERBOSE)) {
            this.getLogger().info("IGNORING STEP");
        }
    }

    @Override
    public void stepPending() {
        this.getLoggingLevel();
        if (this.loggingLevelIsAtLeast(LoggingLevel.VERBOSE)) {
            this.getLogger().info("PENDING STEP");
        }
    }

    @Override
    public void stepPending(String message) {
        this.getLoggingLevel();
        if (this.loggingLevelIsAtLeast(LoggingLevel.VERBOSE)) {
            this.getLogger().info("PENDING STEP (" + message + ")");
        }
    }

    @Override
    public void testFailed(TestOutcome testOutcome, Throwable cause) {
    }

    @Override
    public void testIgnored() {
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info("TEST IGNORED");
        }
    }

    @Override
    public void notifyScreenChange() {
    }

    @Override
    public void useExamplesFrom(DataTable table) {
    }

    @Override
    public void exampleStarted(Map<String, String> data) {
    }

    @Override
    public void exampleFinished() {
    }

    @Override
    public void assumptionViolated(String message) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info("ASSUMPTION VIOLATED");
        }
    }

    private static enum HeadingStyle {
        NORMAL,
        ASCII;

    }
}

