/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.history;

import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class ProgressSnapshot
implements Comparable<ProgressSnapshot> {
    private final DateTime time;
    private final String requirementType;
    private final int total;
    private final int estimated;
    private final int completed;
    private final int failed;
    private final String buildId;

    private ProgressSnapshot(DateTime time, String requirementType, int total, int completed, int estimated, int failed, String buildId) {
        this.time = time;
        this.requirementType = requirementType;
        this.total = total;
        this.completed = completed;
        this.estimated = estimated;
        this.failed = failed;
        this.buildId = buildId;
    }

    public static ProgressSnapshotBuilder forRequirementType(String requirementType) {
        return new ProgressSnapshotBuilder(requirementType);
    }

    public static ProgressSnapshot copyOf(ProgressSnapshot progressSnapshot) {
        return new ProgressSnapshot(progressSnapshot.time, progressSnapshot.requirementType, progressSnapshot.total, progressSnapshot.completed, progressSnapshot.estimated, progressSnapshot.failed, progressSnapshot.buildId);
    }

    public DateTime getTime() {
        return this.time;
    }

    public String getRequirementType() {
        return this.requirementType;
    }

    public int getTotal() {
        return this.total;
    }

    public int getCompleted() {
        return this.completed;
    }

    public int getEstimated() {
        return this.estimated;
    }

    public int getFailed() {
        return this.failed;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public String getFormattedTime() {
        return this.time.toString("yyyy/MM/dd hh:mm:ss");
    }

    @Override
    public int compareTo(ProgressSnapshot other) {
        if (this == other) {
            return 0;
        }
        return this.getTime().compareTo((ReadableInstant)other.getTime());
    }

    /* synthetic */ ProgressSnapshot(DateTime dateTime, String string, int n, int n2, int n3, int n4, String string2, ProgressSnapshot progressSnapshot) {
        this(dateTime, string, n, n2, n3, n4, string2);
    }

    public static class ProgressSnapshotBuilder {
        private final String requirementType;
        private int completed;
        private int estimated;
        private int total;
        private int failing;
        private DateTime time;
        private boolean useEstimatedValue = false;

        public ProgressSnapshotBuilder(String requirementType) {
            this.requirementType = requirementType;
            this.time = DateTime.now();
        }

        public ProgressSnapshotBuilder atTime(DateTime time) {
            this.time = time;
            return this;
        }

        public ResultCountBuilder with(int count) {
            return new ResultCountBuilder(count, this);
        }

        public ResultCountBuilder and(int count) {
            return new ResultCountBuilder(count, this);
        }

        public ProgressSnapshotBuilder outOf(int totalRequirements) {
            this.total = totalRequirements;
            return this;
        }

        public ProgressSnapshot forBuild(String buildId) {
            return new ProgressSnapshot(this.time, this.requirementType, this.total, this.completed, this.useEstimatedValue ? this.estimated : this.completed, this.failing, buildId, null);
        }

        public static class ResultCountBuilder {
            private final int count;
            private final ProgressSnapshotBuilder snapshotBuilder;

            public ResultCountBuilder(int count, ProgressSnapshotBuilder snapshotBuilder) {
                this.count = count;
                this.snapshotBuilder = snapshotBuilder;
            }

            public ProgressSnapshotBuilder completed() {
                this.snapshotBuilder.completed = this.count;
                return this.snapshotBuilder;
            }

            public ProgressSnapshotBuilder estimated() {
                this.snapshotBuilder.estimated = this.count;
                this.snapshotBuilder.useEstimatedValue = true;
                return this.snapshotBuilder;
            }

            public ProgressSnapshotBuilder failed() {
                this.snapshotBuilder.failing = this.count;
                return this.snapshotBuilder;
            }
        }
    }
}

