/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reflection;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ClassFinder {
    private final ClassLoader classLoader;
    private final Class annotation;

    private ClassFinder(ClassLoader classLoader, Class annotation) {
        this.classLoader = classLoader;
        this.annotation = annotation;
    }

    private ClassFinder(ClassLoader classLoader) {
        this(classLoader, null);
    }

    public static ClassFinder loadClasses() {
        return new ClassFinder(ClassFinder.getDefaultClassLoader());
    }

    public ClassFinder annotatedWith(Class annotation) {
        return new ClassFinder(this.classLoader, annotation);
    }

    public List<Class<?>> fromPackage(String packageName) {
        return this.filtered(ClassFinder.getClasses(packageName));
    }

    private List<Class<?>> filtered(Collection<Class<?>> classes) {
        ArrayList matchingClasses = new ArrayList();
        for (Class<?> clazz : classes) {
            if (!this.matchesConstraints(clazz)) continue;
            matchingClasses.add(clazz);
        }
        return matchingClasses;
    }

    private boolean matchesConstraints(Class clazz) {
        if (this.annotation == null) {
            return true;
        }
        return clazz.getAnnotation(this.annotation) != null;
    }

    private static ClassLoader getDefaultClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static boolean isNotAnInnerClass(String className) {
        return !className.contains("$");
    }

    public static List<Class<?>> getClasses(String packageName) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            assert (classLoader != null);
            String path = packageName.replace('.', '/');
            Enumeration<URL> resources = classLoader.getResources(path);
            ArrayList dirs = Lists.newArrayList();
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                dirs.add(resource.getFile());
            }
            TreeSet classes = Sets.newTreeSet();
            for (String directory : dirs) {
                classes.addAll(ClassFinder.findClasses(directory, packageName));
            }
            ArrayList classList = Lists.newArrayList();
            for (String className : classes) {
                try {
                    if (!className.startsWith(packageName) || !ClassFinder.isNotAnInnerClass(className)) continue;
                    classList.add(Class.forName(className));
                }
                catch (Throwable throwable) {
                    System.out.println("Could not load class " + className);
                }
            }
            return classList;
        }
        catch (Exception exception) {
            return Collections.EMPTY_LIST;
        }
    }

    private static TreeSet<String> findClasses(String directory, String packageName) throws Exception {
        File[] files;
        File dir;
        TreeSet classes = Sets.newTreeSet();
        if (directory.startsWith("file:") && directory.contains("!")) {
            String[] split = directory.split("!");
            URL jar = new URL(split[0]);
            ZipInputStream zip = new ZipInputStream(jar.openStream());
            ZipEntry entry = null;
            while ((entry = zip.getNextEntry()) != null) {
                String className;
                if (!entry.getName().endsWith(".class") || !ClassFinder.isNotAnInnerClass(className = ClassFinder.classNameFor(entry))) continue;
                classes.add(className);
            }
        }
        if (!(dir = new File(directory)).exists()) {
            return classes;
        }
        File[] fileArray = files = dir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                classes.addAll(ClassFinder.findClasses(file.getAbsolutePath(), String.valueOf(packageName) + "." + file.getName()));
            } else if (file.getName().endsWith(".class")) {
                classes.add(String.valueOf(packageName) + '.' + file.getName().substring(0, file.getName().length() - 6));
            }
            ++n2;
        }
        return classes;
    }

    private static String classNameFor(ZipEntry entry) {
        return entry.getName().replaceAll("[$].*", "").replaceAll("[.]class", "").replace('/', '.');
    }
}

