/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.json;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.json.ClassTypeAdapter;
import net.thucydides.core.reports.json.JSONConverter;
import net.thucydides.core.reports.json.TestOutcomeSerializer;
import net.thucydides.core.reports.json.ThrowableClassAdapter;

public class GsonJSONConverter
implements JSONConverter {
    private Gson gson;

    public GsonJSONConverter() {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        builder.registerTypeAdapter(TestOutcome.class, (Object)new TestOutcomeSerializer());
        builder.registerTypeAdapter(Class.class, (Object)new ClassTypeAdapter());
        builder.registerTypeAdapter(Throwable.class, (Object)new ThrowableClassAdapter());
        this.gson = builder.create();
    }

    @Override
    public void writeJsonToFile(TestOutcome testOutcome, Path report) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (JsonWriter jsonWriter = new JsonWriter((Writer)Files.newBufferedWriter(report, Charset.defaultCharset(), new OpenOption[0]));){
            this.gson.toJson((Object)testOutcome, TypeToken.of(TestOutcome.class).getType(), jsonWriter);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public TestOutcome fromJson(File jsonTestOutcome) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = Files.newBufferedReader(jsonTestOutcome.toPath(), Charset.defaultCharset());){
            return (TestOutcome)this.gson.fromJson((Reader)reader, TestOutcome.class);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

