/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.json;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.AcceptanceTestLoader;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.OutcomeFormat;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.json.JSONConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONTestOutcomeReporter
implements AcceptanceTestReporter,
AcceptanceTestLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSONTestOutcomeReporter.class);
    private File outputDirectory;
    private transient String qualifier;
    JSONConverter jsonConverter = (JSONConverter)Injectors.getInjector().getInstance(JSONConverter.class);

    @Override
    public String getName() {
        return "json";
    }

    @Override
    public File generateReportFor(TestOutcome testOutcome, TestOutcomes allTestOutcomes) throws IOException {
        TestOutcome storedTestOutcome = testOutcome.withQualifier(this.qualifier);
        Preconditions.checkNotNull((Object)this.outputDirectory);
        String reportFilename = this.reportFor(storedTestOutcome);
        File report = new File(this.getOutputDirectory(), reportFilename);
        this.jsonConverter.writeJsonToFile(storedTestOutcome, report.toPath());
        return report;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    private String reportFor(TestOutcome testOutcome) {
        return testOutcome.withQualifier(this.qualifier).getReportName(ReportType.JSON);
    }

    @Override
    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    @Override
    public void setResourceDirectory(String resourceDirectoryPath) {
    }

    @Override
    public Optional<TestOutcome> loadReportFrom(File reportFile) {
        try {
            TestOutcome fromJson = this.jsonConverter.fromJson(reportFile);
            return Optional.of((Object)fromJson);
        }
        catch (JsonMappingException mappingException) {
            throw new RuntimeException("Error loading JSON test outcomes", mappingException);
        }
        catch (Exception exception) {
            LOGGER.warn("this file was not a valid JSON Thucydides test report: " + reportFile.getName());
            return Optional.absent();
        }
    }

    @Override
    public List<TestOutcome> loadReportsFrom(File outputDirectory) {
        File[] reportFiles = this.getAllJsonFilesFrom(outputDirectory);
        ArrayList testOutcomes = Lists.newArrayList();
        if (reportFiles != null) {
            File[] fileArray = reportFiles;
            int n = reportFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File reportFile = fileArray[n2];
                testOutcomes.addAll(this.loadReportFrom(reportFile).asSet());
                ++n2;
            }
        }
        return testOutcomes;
    }

    private File[] getAllJsonFilesFrom(File reportsDirectory) {
        return reportsDirectory.listFiles(new JsonFilenameFilter());
    }

    @Override
    public Optional<OutcomeFormat> getFormat() {
        return Optional.of((Object)((Object)OutcomeFormat.JSON));
    }

    private static final class JsonFilenameFilter
    implements FilenameFilter {
        private JsonFilenameFilter() {
        }

        @Override
        public boolean accept(File file, String filename) {
            return filename.toLowerCase(Locale.getDefault()).endsWith(".json");
        }
    }
}

