/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.json.jackson;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.json.JSONConverter;
import net.thucydides.core.reports.json.jackson.TestOutcomeModule;
import net.thucydides.core.util.EnvironmentVariables;

public class JacksonJSONConverter
implements JSONConverter {
    private final ObjectMapper mapper;
    private final ObjectReader reader;
    private final ObjectWriter writer;
    private final EnvironmentVariables environmentVariables;

    @Inject
    public JacksonJSONConverter(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.mapper = new ObjectMapper();
        this.mapper.registerModule((Module)new JodaModule());
        this.mapper.registerModule((Module)new GuavaModule());
        this.mapper.registerModule((Module)new TestOutcomeModule());
        this.mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.reader = this.mapper.reader(TestOutcome.class);
        this.writer = this.mapper.writerWithType(TestOutcome.class);
    }

    protected ObjectMapper getMapper() {
        return this.mapper;
    }

    @Override
    public TestOutcome fromJson(File jsonTestOutcome) throws IOException {
        return (TestOutcome)this.reader.readValue(jsonTestOutcome);
    }

    @Override
    public void writeJsonToFile(TestOutcome testOutcome, Path report) throws IOException {
        if (this.usePrettyPrinting()) {
            this.writer.withDefaultPrettyPrinter().writeValue(report.toFile(), (Object)testOutcome);
        } else {
            this.writer.writeValue(report.toFile(), (Object)testOutcome);
        }
    }

    private boolean usePrettyPrinting() {
        return this.environmentVariables.getPropertyAsBoolean(ThucydidesSystemProperty.JSON_PRETTY_PRINTING, false);
    }
}

