/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.json;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.model.TestTag;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

public class TestOutcomeSerializer
implements JsonSerializer<TestOutcome>,
JsonDeserializer<TestOutcome> {
    private static final String TITLE_FIELD = "title";
    private static final String NAME_FIELD = "name";
    private static final String DESCRIPTION_FIELD = "description";
    private static final String STEPS_FIELD = "steps";
    private static final String SUCCESSFUL_FIELD = "successful";
    private static final String FAILURES_FIELD = "failures";
    private static final String ERRORS_FIELD = "errors";
    private static final String SKIPPED_FIELD = "skipped";
    private static final String IGNORED_FIELD = "ignored";
    private static final String PENDING_FIELD = "pending";
    private static final String RESULT_FIELD = "result";
    private static final String TEST_STEPS = "test-steps";
    private static final String USER_STORY = "user-story";
    private static final String ISSUES = "issues";
    private static final String VERSIONS = "versions";
    private static final String TAGS = "tags";
    private static final String QUALIFIER_FIELD = "qualifier";
    private static final String DURATION = "duration";
    private static final String TIMESTAMP = "timestamp";
    private static final String BATCH_START_TIME = "batchStartTime";
    private static final String SESSION_ID = "session-id";
    private static final String EXAMPLES = "examples";
    private static final String MANUAL = "manual";
    public static final String NEW_LINE_CHAR = "\n";
    public static final String ESCAPE_CHAR_FOR_NEW_LINE = "&#10;";
    private static final String TEST_CASE_FIELD = "test-case";
    private static final String PROJECT_FIELD = "project";

    public JsonElement serialize(TestOutcome testOutcome, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = new JsonObject();
        obj.addProperty(TITLE_FIELD, this.escape(this.titleFrom(testOutcome)));
        obj.addProperty(NAME_FIELD, this.nameFrom(testOutcome));
        if (testOutcome.getDescription() != null) {
            obj.addProperty(DESCRIPTION_FIELD, this.escape(this.descriptionFrom(testOutcome)));
        }
        obj.add(TEST_CASE_FIELD, context.serialize(testOutcome.getTestCase()));
        if (testOutcome.getProject() != null) {
            obj.add(PROJECT_FIELD, context.serialize((Object)testOutcome.getProject()));
        }
        obj.addProperty(RESULT_FIELD, testOutcome.getResult().name());
        if (testOutcome.getQualifier() != null && testOutcome.getQualifier().isPresent()) {
            obj.addProperty(QUALIFIER_FIELD, this.escape((String)testOutcome.getQualifier().get()));
        }
        obj.addProperty(STEPS_FIELD, Integer.toString(testOutcome.countTestSteps()));
        obj.addProperty(SUCCESSFUL_FIELD, Integer.toString(testOutcome.getSuccessCount()));
        obj.addProperty(FAILURES_FIELD, Integer.toString(testOutcome.getFailureCount()));
        if (testOutcome.getErrorCount() > 0) {
            obj.addProperty(ERRORS_FIELD, Integer.toString(testOutcome.getErrorCount()));
        }
        obj.addProperty(SKIPPED_FIELD, Integer.toString(testOutcome.getSkippedCount()));
        obj.addProperty(IGNORED_FIELD, Integer.toString(testOutcome.getIgnoredCount()));
        obj.addProperty(PENDING_FIELD, Integer.toString(testOutcome.getPendingCount()));
        obj.addProperty(DURATION, Long.toString(testOutcome.getDuration()));
        obj.addProperty(TIMESTAMP, this.formattedTimestamp(testOutcome.getStartTime()));
        if (testOutcome.has().testRunTimestamp()) {
            obj.addProperty(BATCH_START_TIME, this.formattedTimestamp(testOutcome.getTestRunTimestamp()));
        }
        if (testOutcome.isManual()) {
            obj.addProperty(MANUAL, "true");
        }
        if (StringUtils.isNotEmpty((CharSequence)testOutcome.getSessionId())) {
            obj.addProperty(SESSION_ID, testOutcome.getSessionId());
        }
        obj.add(USER_STORY, context.serialize((Object)testOutcome.getUserStory()));
        obj.add(ISSUES, context.serialize(testOutcome.getIssues()));
        obj.add(VERSIONS, context.serialize(testOutcome.getVersions()));
        obj.add(TAGS, context.serialize(testOutcome.getTags()));
        obj.add(TEST_STEPS, context.serialize(testOutcome.getTestSteps()));
        obj.add(EXAMPLES, context.serialize((Object)testOutcome.getDataTable()));
        return obj;
    }

    public TestOutcome deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        boolean isManualTest;
        Optional<DateTime> batchStartTime;
        JsonObject outcomeJsonObject = json.getAsJsonObject();
        Class testCase = (Class)context.deserialize((JsonElement)outcomeJsonObject.getAsJsonObject(TEST_CASE_FIELD), Class.class);
        String testOutcomeName = outcomeJsonObject.get(NAME_FIELD).getAsString();
        TestOutcome testOutcome = new TestOutcome(testOutcomeName, testCase);
        testOutcome.setTitle(this.unescape(outcomeJsonObject.get(TITLE_FIELD).getAsString()));
        if (outcomeJsonObject.get(PROJECT_FIELD) != null) {
            String project = outcomeJsonObject.get(PROJECT_FIELD).getAsString();
            testOutcome = testOutcome.forProject(project);
        }
        if (outcomeJsonObject.get(DESCRIPTION_FIELD) != null) {
            testOutcome.setDescription(this.unescape(outcomeJsonObject.get(DESCRIPTION_FIELD).getAsString()));
        }
        TestResult savedTestResult = TestResult.valueOf(outcomeJsonObject.get(RESULT_FIELD).getAsString());
        Long duration = this.readDuration(outcomeJsonObject);
        testOutcome.setDuration(duration);
        Optional<DateTime> timestamp = this.readTimestamp(outcomeJsonObject);
        if (timestamp.isPresent()) {
            testOutcome.setStartTime((DateTime)timestamp.get());
        }
        if ((batchStartTime = this.readBatchStartTime(outcomeJsonObject)).isPresent()) {
            testOutcome.setTestRunTimestamp((DateTime)batchStartTime.get());
        }
        if (isManualTest = this.readManualTest(outcomeJsonObject)) {
            testOutcome = testOutcome.asManualTest();
        }
        String sessionId = this.readSessionId(outcomeJsonObject);
        testOutcome.setSessionId(sessionId);
        Story story = (Story)context.deserialize((JsonElement)outcomeJsonObject.getAsJsonObject(USER_STORY), Story.class);
        testOutcome.setUserStory(story);
        testOutcome = this.addQualifierIfPresent(outcomeJsonObject, testOutcome);
        this.addIssuesIfPresent(context, outcomeJsonObject, testOutcome);
        this.addVersionsIfPresent(context, outcomeJsonObject, testOutcome);
        this.addTagsIfPresent(context, outcomeJsonObject, testOutcome);
        JsonArray testStepsJsonArray = outcomeJsonObject.getAsJsonArray(TEST_STEPS);
        for (JsonElement currentJsonElement : testStepsJsonArray) {
            TestStep currentStep = (TestStep)context.deserialize(currentJsonElement, TestStep.class);
            testOutcome.recordStep(currentStep);
        }
        DataTable dataTable = (DataTable)context.deserialize((JsonElement)outcomeJsonObject.getAsJsonObject(EXAMPLES), DataTable.class);
        testOutcome.useExamplesFrom(dataTable);
        if (testOutcome.getStepCount().equals(0)) {
            testOutcome.setAnnotatedResult(savedTestResult);
        }
        return testOutcome;
    }

    private TestOutcome addQualifierIfPresent(JsonObject outcomeJsonObject, TestOutcome testOutcome) {
        JsonElement qualifierField = outcomeJsonObject.get(QUALIFIER_FIELD);
        if (qualifierField != null) {
            testOutcome = testOutcome.withQualifier(this.unescape(qualifierField.getAsString()));
        }
        return testOutcome;
    }

    private void addTagsIfPresent(JsonDeserializationContext context, JsonObject outcomeJsonObject, TestOutcome testOutcome) {
        HashSet tags = Sets.newHashSet((Iterable)Lambda.convert((Object)context.deserialize((JsonElement)outcomeJsonObject.getAsJsonArray(TAGS), Set.class), this.toTags()));
        if (tags != null) {
            testOutcome.setTags(tags);
        }
    }

    private Converter<Map, TestTag> toTags() {
        return new Converter<Map, TestTag>(){

            public TestTag convert(Map from) {
                return TestTag.withName((String)from.get(TestOutcomeSerializer.NAME_FIELD)).andType((String)from.get("type"));
            }
        };
    }

    private void addIssuesIfPresent(JsonDeserializationContext context, JsonObject outcomeJsonObject, TestOutcome testOutcome) {
        Set issues = (Set)context.deserialize((JsonElement)outcomeJsonObject.getAsJsonArray(ISSUES), Set.class);
        if (issues != null) {
            ArrayList<String> issuesAsString = new ArrayList<String>();
            issuesAsString.addAll(issues);
            testOutcome.addIssues(issuesAsString);
        }
    }

    private void addVersionsIfPresent(JsonDeserializationContext context, JsonObject outcomeJsonObject, TestOutcome testOutcome) {
        Set versions = (Set)context.deserialize((JsonElement)outcomeJsonObject.getAsJsonArray(VERSIONS), Set.class);
        if (versions != null) {
            ArrayList<String> versionsAsString = new ArrayList<String>();
            versionsAsString.addAll(versions);
            testOutcome.addVersions(versionsAsString);
        }
    }

    private String escape(String attribute) {
        return StringUtils.replace((String)attribute, (String)NEW_LINE_CHAR, (String)ESCAPE_CHAR_FOR_NEW_LINE);
    }

    private String unescape(String attribute) {
        return StringUtils.replace((String)attribute, (String)ESCAPE_CHAR_FOR_NEW_LINE, (String)NEW_LINE_CHAR);
    }

    private String titleFrom(TestOutcome testOutcome) {
        return testOutcome.getTitle();
    }

    private String nameFrom(TestOutcome testOutcome) {
        return testOutcome.getMethodName();
    }

    private String descriptionFrom(TestOutcome testOutcome) {
        return testOutcome.getDescription();
    }

    private String formattedTimestamp(DateTime startTime) {
        return startTime.toString();
    }

    private long readDuration(JsonObject jsonObject) {
        JsonElement durationElement = jsonObject.get(DURATION);
        if (durationElement != null && StringUtils.isNumeric((CharSequence)durationElement.getAsString())) {
            return Long.parseLong(jsonObject.get(DURATION).getAsString());
        }
        return 0L;
    }

    private Optional<DateTime> readTimestamp(JsonObject jsonObject) {
        DateTime timestamp = null;
        JsonElement timestampElement = jsonObject.get(TIMESTAMP);
        if (timestampElement != null) {
            String timestampValue = jsonObject.get(TIMESTAMP).getAsString();
            timestamp = DateTime.parse((String)timestampValue);
        }
        return Optional.fromNullable(timestamp);
    }

    private Optional<DateTime> readBatchStartTime(JsonObject jsonObject) {
        DateTime timestamp = null;
        JsonElement timestampElement = jsonObject.get(BATCH_START_TIME);
        if (timestampElement != null) {
            String timestampValue = jsonObject.get(BATCH_START_TIME).getAsString();
            timestamp = DateTime.parse((String)timestampValue);
        }
        return Optional.fromNullable(timestamp);
    }

    private boolean readManualTest(JsonObject jsonObject) {
        boolean isManualTest = false;
        JsonElement manualTestAttribute = jsonObject.get(MANUAL);
        if (manualTestAttribute != null) {
            isManualTest = Boolean.valueOf(manualTestAttribute.getAsString());
        }
        return isManualTest;
    }

    private String readSessionId(JsonObject jsonObject) {
        JsonElement jsonElement = jsonObject.get(SESSION_ID);
        if (jsonElement != null) {
            return jsonElement.getAsString();
        }
        return null;
    }
}

