/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.model.FailureCause;

public class RootCauseAnalyzer {
    private final Throwable thrownException;
    private static final List<String> MASKED_PACKAGES = ImmutableList.of((Object)"sun.", (Object)"java.", (Object)"org.junit", (Object)"org.fest", (Object)"org.hamcrest", (Object)"org.openqa.selenium", (Object)"org.spockframework", (Object)"com.intellij", (Object)"net.sf.cglib", (Object)"org.codehaus.groovy", (Object)"org.jbehave", (Object)"net.thucydides.core", (Object[])new String[]{"net.thucydides.jbehave", "net.thucydides.junit"});

    public RootCauseAnalyzer(Throwable thrownException) {
        this.thrownException = thrownException;
    }

    public FailureCause getRootCause() {
        Throwable originalException = this.thrownException.getCause() != null ? this.thrownException.getCause() : this.thrownException;
        return new FailureCause(originalException, this.sanitized(originalException.getStackTrace()));
    }

    public String getClassname() {
        return this.getRootCause().getErrorType();
    }

    public String getMessage() {
        return this.getRootCause().getMessage();
    }

    private void sanitizeStackDump(FailureCause cause) {
        cause.setStackTrace(this.sanitized(cause.getStackTrace()));
    }

    private StackTraceElement[] sanitized(StackTraceElement[] stackTrace) {
        ArrayList cleanStackTrace = Lists.newArrayList();
        StackTraceElement[] stackTraceElementArray = stackTrace;
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            if (this.shouldDisplayInStackTrace(element)) {
                cleanStackTrace.add(element);
            }
            ++n2;
        }
        return cleanStackTrace.toArray(new StackTraceElement[0]);
    }

    private boolean shouldDisplayInStackTrace(StackTraceElement element) {
        if (element.getClassName().contains("$$")) {
            return false;
        }
        for (String maskedPackage : MASKED_PACKAGES) {
            if (!element.getClassName().startsWith(maskedPackage)) continue;
            return false;
        }
        return true;
    }
}

