/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;

public class VersionProvider {
    private final EnvironmentVariables environmentVariables;

    public VersionProvider() {
        this((EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    public VersionProvider(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public String getVersion() {
        String path = "/version.properties";
        InputStream stream = this.getClass().getResourceAsStream(path);
        if (stream == null) {
            return "UNKNOWN";
        }
        Properties props = new Properties();
        try {
            props.load(stream);
            stream.close();
            return (String)props.get("version");
        }
        catch (IOException iOException) {
            return "UNKNOWN";
        }
    }

    public String getBuildNumberText() {
        return this.environmentVariables.getValue(this.buildNumberVariable(), "UNKNOWN");
    }

    private String buildNumberVariable() {
        return this.environmentVariables.getProperty("build.number.variable", "BUILD_NUMBER");
    }
}

