/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import net.thucydides.core.annotations.Feature;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.Stories;
import net.thucydides.core.model.features.ApplicationFeature;
import net.thucydides.core.util.NameConverter;

public class Story {
    private String id;
    private String storyName;
    private String storyClassName;
    private String path;
    private String narrative;
    private ApplicationFeature feature;

    protected Story(Class<?> userStoryClass) {
        this.id = userStoryClass.getCanonicalName();
        this.storyClassName = userStoryClass.getName();
        this.storyName = NameConverter.humanize(userStoryClass.getSimpleName());
        this.feature = this.findFeatureFrom(userStoryClass);
        this.path = this.pathOf(userStoryClass);
    }

    private String pathOf(Class<?> userStoryClass) {
        String canonicalName = userStoryClass.getCanonicalName();
        int lastDot = canonicalName.lastIndexOf(".");
        if (lastDot > 0) {
            return canonicalName.substring(0, lastDot);
        }
        return "";
    }

    private ApplicationFeature findFeatureFrom(Class<?> userStoryClass) {
        if (Story.getFeatureClass(userStoryClass) != null) {
            return ApplicationFeature.from(Story.getFeatureClass(userStoryClass));
        }
        return null;
    }

    public Story(String id, String storyName, String storyClassName, String path, ApplicationFeature feature) {
        this.id = id;
        this.storyName = storyName;
        this.storyClassName = storyClassName;
        this.feature = feature;
        this.path = path;
        this.narrative = null;
    }

    public Story(String id, String storyName, String storyClassName, String path, ApplicationFeature feature, String narrative) {
        this.id = id;
        this.storyName = storyName;
        this.storyClassName = storyClassName;
        this.feature = feature;
        this.path = path;
        this.narrative = narrative;
    }

    protected Story(String id, String storyName, ApplicationFeature feature, String path) {
        this.id = id;
        this.storyName = storyName;
        this.storyClassName = null;
        this.feature = feature;
        this.path = path;
    }

    public String getId() {
        return this.id;
    }

    public static Story from(Class<?> userStoryClass) {
        return new Story(userStoryClass);
    }

    public static Story withId(String storyId, String storyName) {
        return new Story(storyId, storyName, null, null, null);
    }

    public Story withNarrative(String narrative) {
        return new Story(this.id, this.storyName, this.storyClassName, this.path, this.feature, narrative);
    }

    public static Story withIdAndPath(String storyId, String storyName, String storyPath) {
        return new Story(storyId, storyName, null, storyPath, null);
    }

    public static Story called(String storyName) {
        return new Story(storyName, storyName, null, null, null);
    }

    public static Story withId(String storyId, String storyName, String featureClassName, String featureName) {
        return new Story(storyId, storyName, new ApplicationFeature(featureClassName, featureName), null);
    }

    public static Story withIdAndPathAndFeature(String storyId, String storyName, String storyPath, String featureClassName, String featureName) {
        return new Story(storyId, storyName, new ApplicationFeature(featureClassName, featureName), storyPath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Story)) {
            return false;
        }
        Story story = (Story)o;
        if (!this.id.equals(story.id)) {
            return false;
        }
        return !(this.path != null ? !this.path.equals(story.path) : story.path != null);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        return result;
    }

    public static Class<?> getFeatureClass(Class<?> userStoryClass) {
        Class<?> enclosingClass;
        if (userStoryClass != null && Story.isAFeature(enclosingClass = userStoryClass.getEnclosingClass())) {
            return enclosingClass;
        }
        return null;
    }

    private static boolean isAFeature(Class<?> enclosingClass) {
        return enclosingClass != null && enclosingClass.getAnnotation(Feature.class) != null;
    }

    public static Class<?> testedInTestCase(Class<?> testClass) {
        net.thucydides.core.annotations.Story story = testClass.getAnnotation(net.thucydides.core.annotations.Story.class);
        if (story != null) {
            return story.value();
        }
        return null;
    }

    public String getName() {
        return this.storyName;
    }

    public String getStoryClassName() {
        return this.storyClassName;
    }

    public String getReportName(ReportType type) {
        return Stories.reportFor(this, type);
    }

    public String getReportName() {
        return this.getReportName(ReportType.ROOT);
    }

    public ApplicationFeature getFeature() {
        return this.feature;
    }

    public String getPath() {
        return this.path;
    }

    public String getStoryName() {
        return this.storyName;
    }

    public String getNarrative() {
        return this.narrative;
    }

    public Story withPath(String storyPath) {
        return new Story(this.id, this.storyName, this.feature, storyPath);
    }
}

