/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thucydides.core.geometry.Line;
import net.thucydides.core.geometry.Point;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.NumericalFormatter;
import net.thucydides.core.reports.ReportOptions;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.history.ProgressSnapshot;
import net.thucydides.core.reports.history.TestHistory;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.reports.html.HtmlReporter;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.requirements.reports.RequirementsOutcomes;
import net.thucydides.core.util.Inflector;
import org.joda.time.DateTime;

public class HtmlProgressReporter
extends HtmlReporter {
    private static final String DEFAULT_PROGRESS_REPORT = "freemarker/progress-report.ftl";
    private static final String REPORT_NAME = "progress-report.html";
    private final IssueTracking issueTracking;
    private final TestHistory testHistory;

    public HtmlProgressReporter(IssueTracking issueTracking, TestHistory testHistory) {
        this.issueTracking = issueTracking;
        this.testHistory = testHistory;
    }

    public File generateReportFor(RequirementsOutcomes requirementsOutcomes) throws IOException {
        return this.generateReportFor(requirementsOutcomes, requirementsOutcomes.getTestOutcomes(), REPORT_NAME);
    }

    public File generateReportFor(RequirementsOutcomes requirementsOutcomes, TestOutcomes testOutcomes, String filename) throws IOException {
        Preconditions.checkNotNull((Object)this.getOutputDirectory());
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("progress", this.getEstimatedDeliveryDate(this.testHistory.getProgress()));
        context.put("requirements", requirementsOutcomes);
        context.put("testOutcomes", requirementsOutcomes.getTestOutcomes());
        context.put("allTestOutcomes", testOutcomes);
        context.put("reportName", new ReportNameProvider());
        context.put("absoluteReportName", new ReportNameProvider());
        context.put("timestamp", this.timestampFrom(testOutcomes));
        this.addFormattersToContext(context);
        String htmlContents = this.mergeTemplate(DEFAULT_PROGRESS_REPORT).usingContext(context);
        this.copyResourcesToOutputDirectory();
        return this.writeReportToOutputDirectory(filename, htmlContents);
    }

    private List<ProgressSnapshot> getEstimatedDeliveryDate(List<ProgressSnapshot> progress) {
        if (progress.size() > 1) {
            ProgressSnapshot firstSnapshot = progress.get(0);
            ProgressSnapshot latestSnapshot = progress.get(progress.size() - 1);
            Optional<Point> intersection = this.calculateIntersection(progress);
            DateTime origin = firstSnapshot.getTime();
            if (intersection.isPresent() && this.isAfterLatestSnapshot(origin, (Point)intersection.get(), latestSnapshot)) {
                ProgressSnapshot endOfSeriesEntry = this.createEndOfSeriesEntry(latestSnapshot, intersection);
                ProgressSnapshot estimatedDoneEntry = this.createNewEstimatedDoneDate(origin, latestSnapshot, intersection);
                ArrayList progressWithEstimatedDone = Lists.newArrayList(progress);
                progressWithEstimatedDone.add(endOfSeriesEntry);
                progressWithEstimatedDone.add(estimatedDoneEntry);
                return progressWithEstimatedDone;
            }
        }
        return progress;
    }

    private ProgressSnapshot createNewEstimatedDoneDate(DateTime origin, ProgressSnapshot latestSnapshot, Optional<Point> intersection) {
        long dateTimeInstant = origin.getMillis() + ((Point)intersection.get()).getX().round(new MathContext(0, RoundingMode.HALF_UP)).longValue();
        DateTime estimationCompletionDate = new DateTime(dateTimeInstant);
        return ProgressSnapshot.forRequirementType(latestSnapshot.getRequirementType()).atTime(estimationCompletionDate).with(latestSnapshot.getTotal()).estimated().and(0).failed().and(0).completed().outOf(latestSnapshot.getTotal()).forBuild("ESTIMATED_DONE_DATE");
    }

    private ProgressSnapshot createEndOfSeriesEntry(ProgressSnapshot latestSnapshot, Optional<Point> intersection) {
        return ProgressSnapshot.forRequirementType(latestSnapshot.getRequirementType()).atTime(latestSnapshot.getTime().plus(1L).secondOfDay().getDateTime()).and(0).failed().and(0).completed().and(latestSnapshot.getCompleted()).estimated().outOf(latestSnapshot.getTotal()).forBuild("ESTIMATED_DONE_DATE");
    }

    private Optional<Point> calculateIntersection(List<ProgressSnapshot> progressSnapshots) {
        ProgressSnapshot firstSnapshot = progressSnapshots.get(0);
        ProgressSnapshot firstSnapshotWithSpecifications = this.firstSnapshotWithSpecificationsIn(progressSnapshots);
        ProgressSnapshot latestSnapshot = progressSnapshots.get(progressSnapshots.size() - 1);
        Line doneLine = this.calculateDoneLine(firstSnapshot, latestSnapshot);
        Line specifiedLine = this.calculateSpecifiedLine(firstSnapshotWithSpecifications, latestSnapshot);
        return doneLine.intersectionWith(specifiedLine);
    }

    private ProgressSnapshot firstSnapshotWithSpecificationsIn(List<ProgressSnapshot> progressSnapshots) {
        for (ProgressSnapshot progressSnapshot : progressSnapshots) {
            if (progressSnapshot.getTotal() <= 0) continue;
            return progressSnapshot;
        }
        return progressSnapshots.get(0);
    }

    private boolean isAfterLatestSnapshot(DateTime origin, Point intersection, ProgressSnapshot latestSnapshot) {
        Point finalDonePoint = Point.at(latestSnapshot.getTime().getMillis() - origin.getMillis(), (long)latestSnapshot.getCompleted());
        return intersection.getX().compareTo(finalDonePoint.getX()) > 0;
    }

    private Line calculateDoneLine(ProgressSnapshot firstSnapshot, ProgressSnapshot latestSnapshot) {
        DateTime origin = firstSnapshot.getTime();
        Point initialDonePoint = Point.at(this.normalizedTime(firstSnapshot, origin), (long)firstSnapshot.getCompleted());
        Point finalDonePoint = Point.at(this.normalizedTime(latestSnapshot, origin), (long)latestSnapshot.getCompleted());
        return Line.from(initialDonePoint).horizontally().to(finalDonePoint);
    }

    private Line calculateSpecifiedLine(ProgressSnapshot firstSnapshot, ProgressSnapshot latestSnapshot) {
        DateTime origin = firstSnapshot.getTime();
        Point initialPoint = Point.at(this.normalizedTime(firstSnapshot, origin), (long)firstSnapshot.getTotal());
        Point finalPoint = Point.at(this.normalizedTime(latestSnapshot, origin), (long)latestSnapshot.getTotal());
        return Line.from(initialPoint).horizontally().to(finalPoint);
    }

    private long normalizedTime(ProgressSnapshot snapshot, DateTime origin) {
        return snapshot.getTime().getMillis() - origin.getMillis();
    }

    private void addFormattersToContext(Map<String, Object> context) {
        Formatter formatter = new Formatter(this.issueTracking);
        context.put("formatter", formatter);
        context.put("formatted", new NumericalFormatter());
        context.put("inflection", Inflector.getInstance());
        context.put("reportOptions", new ReportOptions(this.getEnvironmentVariables()));
    }
}

