/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.screenshots;

import com.google.common.base.Optional;
import java.lang.reflect.Method;
import net.thucydides.core.annotations.BlurScreenshots;
import net.thucydides.core.reflection.StackTraceAnalyser;
import net.thucydides.core.screenshots.BlurLevel;

public class ScreenshotBlurCheck {
    public Optional<BlurLevel> blurLevel() {
        return this.fromAnnotation();
    }

    private Optional<BlurLevel> fromAnnotation() {
        StackTraceElement[] stackTrace;
        StackTraceElement[] stackTraceElementArray = stackTrace = new Throwable().getStackTrace();
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            Method callingMethod = StackTraceAnalyser.forStackTraceElement(stackTraceElement).getMethod();
            if (callingMethod != null && callingMethod.getAnnotation(BlurScreenshots.class) != null) {
                return Optional.of((Object)((Object)BlurLevel.valueOf(callingMethod.getAnnotation(BlurScreenshots.class).value().toUpperCase())));
            }
            ++n2;
        }
        return Optional.absent();
    }
}

