/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.requirements.model.CustomFieldValue;
import net.thucydides.core.requirements.model.Example;
import net.thucydides.core.requirements.model.RequirementBuilderNameStep;

public class Requirement
implements Comparable {
    private String displayName;
    private String name;
    private String type;
    private CustomFieldValue narrative;
    private String cardNumber;
    private List<Requirement> children;
    private String parent;
    private List<Example> examples;
    private List<String> releaseVersions;
    private List<CustomFieldValue> customFields;

    public Requirement() {
        this.children = Lists.newArrayList();
        this.examples = Lists.newArrayList();
        this.releaseVersions = Lists.newArrayList();
        this.customFields = Lists.newArrayList();
    }

    protected Requirement(String name, String displayName, String cardNumber, String parent, String type, CustomFieldValue narrative, List<Requirement> children, List<Example> examples, List<String> releaseVersions) {
        this(name, displayName, cardNumber, parent, type, narrative, children, examples, releaseVersions, Collections.EMPTY_LIST);
    }

    protected Requirement(String name, String displayName, String cardNumber, String parent, String type, CustomFieldValue narrative) {
        this(name, displayName, cardNumber, parent, type, narrative, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    protected Requirement(String name, String displayName, String cardNumber, String parent, String type, CustomFieldValue narrative, List<Requirement> children, List<Example> examples, List<String> releaseVersions, List<CustomFieldValue> customFields) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)type);
        this.name = name;
        this.displayName = displayName;
        this.cardNumber = cardNumber;
        this.type = type;
        this.parent = parent;
        this.narrative = narrative;
        this.children = ImmutableList.copyOf(children);
        this.examples = ImmutableList.copyOf(examples);
        this.releaseVersions = ImmutableList.copyOf(releaseVersions);
        this.customFields = ImmutableList.copyOf(customFields);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getType() {
        return this.type;
    }

    public String childType() {
        return !this.children.isEmpty() ? this.children.get(0).getType() : null;
    }

    public CustomFieldValue getNarrative() {
        return this.narrative;
    }

    public List<String> getReleaseVersions() {
        return this.releaseVersions;
    }

    @JsonIgnore
    public int getChildrenCount() {
        return this.children.size();
    }

    public String getParent() {
        return this.parent;
    }

    public List<Requirement> getChildren() {
        return ImmutableList.copyOf(this.children);
    }

    public List<Example> getExamples() {
        return ImmutableList.copyOf(this.examples);
    }

    public Boolean hasExamples() {
        return !this.examples.isEmpty();
    }

    @JsonIgnore
    public int getExampleCount() {
        return this.examples.size();
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public int compareTo(Object otherRequirement) {
        return this.name.compareTo(((Requirement)otherRequirement).getName());
    }

    public static RequirementBuilderNameStep named(String name) {
        return new RequirementBuilderNameStep(name);
    }

    public Requirement withChildren(List<Requirement> children) {
        return new Requirement(this.name, this.displayName, this.cardNumber, this.parent, this.type, this.narrative, children, this.examples, this.releaseVersions);
    }

    public Requirement withParent(String parent) {
        return new Requirement(this.name, this.displayName, this.cardNumber, parent, this.type, this.narrative, this.children, this.examples, this.releaseVersions);
    }

    public Requirement withExample(Example example) {
        ArrayList updatedExamples = Lists.newArrayList(this.examples);
        updatedExamples.add(example);
        return new Requirement(this.name, this.displayName, this.cardNumber, this.parent, this.type, this.narrative, this.children, updatedExamples, this.releaseVersions);
    }

    public Requirement withExamples(List<Example> examples) {
        return new Requirement(this.name, this.displayName, this.cardNumber, this.parent, this.type, this.narrative, this.children, examples, this.releaseVersions);
    }

    public Requirement withReleaseVersions(List<String> releaseVersions) {
        return new Requirement(this.name, this.displayName, this.cardNumber, this.parent, this.type, this.narrative, this.children, this.examples, releaseVersions);
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public List<Requirement> getNestedChildren() {
        ArrayList nestedChildren = Lists.newArrayList();
        for (Requirement child : this.children) {
            nestedChildren.add(child);
            nestedChildren.addAll(child.getNestedChildren());
        }
        return ImmutableList.copyOf((Collection)nestedChildren);
    }

    public TestTag asTag() {
        return TestTag.withName(this.qualifiedName()).andType(this.getType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Requirement that = (Requirement)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.parent != null ? !this.parent.equals(that.parent) : that.parent != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public boolean matches(Requirement that) {
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.cardNumber != null ? !this.cardNumber.equals(that.cardNumber) : that.cardNumber != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Requirement{name='" + this.name + '\'' + ", type='" + this.type + '\'' + " parent = '" + this.parent + '\'' + ", cardNumber='" + this.cardNumber + '\'' + '}';
    }

    public Requirement withChild(Requirement child) {
        ArrayList newChildren = Lists.newArrayList(this.children);
        newChildren.remove(child);
        newChildren.add(child);
        return new Requirement(this.name, this.displayName, this.cardNumber, this.parent, this.type, this.narrative, newChildren, this.examples, this.releaseVersions);
    }

    public CustomFieldSetter withCustomField(String fieldName) {
        return new CustomFieldSetter(this, fieldName);
    }

    public List<CustomFieldValue> getCustomFieldValues() {
        return ImmutableList.copyOf(this.customFields);
    }

    public Optional<CustomFieldValue> getCustomField(String fieldName) {
        for (CustomFieldValue field : this.customFields) {
            if (!field.getName().equals(fieldName)) continue;
            return Optional.of((Object)field);
        }
        return Optional.absent();
    }

    public List<String> getCustomFields() {
        ArrayList customFieldNames = Lists.newArrayList();
        for (CustomFieldValue field : this.customFields) {
            customFieldNames.add(field.getName());
        }
        return customFieldNames;
    }

    public String qualifiedName() {
        return this.qualifier() != null ? String.valueOf(this.qualifier()) + "/" + this.getName() : this.getName();
    }

    public String qualifier() {
        if (this.getCardNumber() != null) {
            return this.getCardNumber();
        }
        return this.getParent() != null ? this.getParent() : null;
    }

    public boolean matchesTag(TestTag testTag) {
        TestTag requirementTag = this.asTag();
        return requirementTag.isAsOrMoreSpecificThan(testTag);
    }

    public class CustomFieldSetter {
        Requirement requirement;
        String fieldName;

        public CustomFieldSetter(Requirement requirement2, String fieldName) {
            this.requirement = requirement2;
            this.fieldName = fieldName;
        }

        public Requirement setTo(String value, String renderedValue) {
            ArrayList customFields = Lists.newArrayList(this.requirement.getCustomFieldValues());
            customFields.add(new CustomFieldValue(this.fieldName, value, renderedValue));
            return new Requirement(this.requirement.name, this.requirement.displayName, this.requirement.cardNumber, this.requirement.parent, this.requirement.type, this.requirement.narrative, this.requirement.children, this.requirement.examples, this.requirement.releaseVersions, customFields);
        }

        public Requirement setTo(String value) {
            return this.setTo(value, null);
        }
    }
}

