/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.SortedMap;
import net.thucydides.core.requirements.ChildrenFirstOrderedMap;
import net.thucydides.core.requirements.model.Requirement;

public class RequirementPersister {
    private final ObjectMapper mapper = new ObjectMapper();
    private final File outputDirectory;
    private final String rootDirectory;

    public RequirementPersister(File outputDirectory, String rootDirectory) {
        this.outputDirectory = outputDirectory;
        this.rootDirectory = rootDirectory;
    }

    public SortedMap<String, Requirement> read() throws IOException {
        ChildrenFirstOrderedMap map = new ChildrenFirstOrderedMap();
        File jsonFile = new File(this.outputDirectory, String.valueOf(this.rootDirectory) + ".json");
        if (!jsonFile.exists()) {
            return map;
        }
        MapType type = this.mapper.getTypeFactory().constructMapType(map.getClass(), String.class, Requirement.class);
        SortedMap storedRequirementsMap = (SortedMap)this.mapper.readValue(jsonFile, (JavaType)type);
        map.putAll(storedRequirementsMap);
        for (Map.Entry entry : storedRequirementsMap.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.contains(".")) continue;
            String parent = key.substring(0, key.lastIndexOf("."));
            Requirement child = (Requirement)entry.getValue();
            this.updateParentChildren(map, parent, child);
        }
        return map;
    }

    private void updateParentChildren(SortedMap<String, Requirement> map, String parent, Requirement entry) {
        Requirement parentRequirement = (Requirement)map.get(parent);
        Requirement updatedParentRequirement = parentRequirement.withChild(entry);
        map.remove(parent);
        map.put(parent, updatedParentRequirement);
    }

    public void write(SortedMap<String, Requirement> map) throws IOException {
        FileOutputStream os = new FileOutputStream(new File(this.outputDirectory, String.valueOf(this.rootDirectory) + ".json"));
        this.mapper.writeValue((OutputStream)os, map);
        os.close();
    }
}

