/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import net.thucydides.core.PendingStepException;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepFailureException;
import net.thucydides.core.webdriver.WebdriverAssertionError;

public class FailureAnalysis {
    public TestResult resultFor(Class testFailureCause) {
        if (this.isA(PendingStepException.class, testFailureCause)) {
            return TestResult.PENDING;
        }
        if (this.isFailure(testFailureCause.getName())) {
            return TestResult.FAILURE;
        }
        return TestResult.ERROR;
    }

    public boolean isFailure(String testFailureCause) {
        if (testFailureCause != null) {
            try {
                if (this.isA(AssertionError.class, Class.forName(testFailureCause))) {
                    return true;
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private boolean isA(Class<?> expectedClass, Class testFailureCause) {
        while (testFailureCause != null) {
            if (testFailureCause.equals(expectedClass)) {
                return true;
            }
            testFailureCause = testFailureCause.getSuperclass();
        }
        return false;
    }

    public TestResult resultFor(Throwable testFailureCause) {
        if (PendingStepException.class.isAssignableFrom(testFailureCause.getClass())) {
            return TestResult.PENDING;
        }
        if (this.isFailureError(testFailureCause)) {
            return TestResult.FAILURE;
        }
        if (this.failingStepException(testFailureCause)) {
            return TestResult.FAILURE;
        }
        return TestResult.ERROR;
    }

    public TestResult resultFor(StepFailure stepFailure) {
        if (stepFailure.getException() == null) {
            return TestResult.FAILURE;
        }
        return this.resultFor(stepFailure.getException());
    }

    private boolean failingStepException(Throwable testFailureCause) {
        return StepFailureException.class.isAssignableFrom(testFailureCause.getClass()) && testFailureCause.getCause() != null && this.isFailureError(testFailureCause.getCause());
    }

    private boolean isFailureError(Throwable testFailureCause) {
        Class<?> failureCauseClass = testFailureCause.getClass();
        if (WebdriverAssertionError.class.isAssignableFrom(failureCauseClass)) {
            return testFailureCause.getCause() == null || AssertionError.class.isAssignableFrom(testFailureCause.getCause().getClass());
        }
        return AssertionError.class.isAssignableFrom(failureCauseClass);
    }
}

