/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.ObjectUtils;

public class TestTag
implements Comparable<TestTag> {
    public static final TestTag EMPTY_TAG = new TestTag("", "");
    private final String name;
    private final String type;

    private TestTag(String name, String type) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)type);
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getShortName() {
        return this.name.contains("/") ? this.name.substring(this.name.indexOf("/") + 1) : this.name;
    }

    public static TestTagBuilder withName(String tagName) {
        return new TestTagBuilder(tagName);
    }

    public static TestTag withValue(String value) {
        if (value.contains(":")) {
            int separatorPosition = value.indexOf(":");
            String type = value.substring(0, separatorPosition).trim();
            String name = value.substring(separatorPosition + 1).trim();
            return TestTag.withName(name).andType(type);
        }
        return TestTag.withName(value.trim()).andType("tag");
    }

    @Override
    public int compareTo(TestTag otherTag) {
        int typeComparison = ObjectUtils.compare((Comparable)((Object)this.getType()), (Comparable)((Object)otherTag.getType()));
        if (typeComparison != 0) {
            return typeComparison;
        }
        return this.getName().compareToIgnoreCase(otherTag.getName());
    }

    public boolean isAsOrMoreSpecificThan(TestTag testTag) {
        if (this.equals(testTag)) {
            return true;
        }
        return this.getName().endsWith("/" + testTag.getName()) && this.getType().equals(testTag.getType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestTag testTag = (TestTag)o;
        if (!this.name.equalsIgnoreCase(testTag.name)) {
            return false;
        }
        return this.type.equalsIgnoreCase(testTag.type);
    }

    public int hashCode() {
        int result = this.name.toLowerCase().hashCode();
        result = 31 * result + this.type.toLowerCase().hashCode();
        return result;
    }

    public String toString() {
        return "TestTag{name='" + this.name + '\'' + ", type='" + this.type + '\'' + '}';
    }

    /* synthetic */ TestTag(String string, String string2, TestTag testTag) {
        this(string, string2);
    }

    public static class TestTagBuilder {
        private final String name;

        public TestTagBuilder(String name) {
            this.name = name;
        }

        public TestTag andType(String type) {
            return new TestTag(this.name, type, null);
        }
    }
}

