/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.batches;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.batches.BatchManager;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SystemVariableBasedBatchManager
implements BatchManager {
    private final AtomicInteger testCaseCount = new AtomicInteger(0);
    private final int batchCount;
    private final int batchNumber;
    private Set<String> registeredTestCases = new CopyOnWriteArraySet<String>();
    private final Logger logger = LoggerFactory.getLogger(SystemVariableBasedBatchManager.class);

    @Inject
    public SystemVariableBasedBatchManager(EnvironmentVariables environmentVariables) {
        this.batchCount = this.getBatchCountFrom(environmentVariables);
        this.batchNumber = environmentVariables.getPropertyAsInteger(ThucydidesSystemProperty.BATCH_NUMBER.getPropertyName(), (Integer)0);
    }

    private int getBatchCountFrom(EnvironmentVariables environmentVariables) {
        int batchCountValue = environmentVariables.getPropertyAsInteger(ThucydidesSystemProperty.BATCH_SIZE.getPropertyName(), (Integer)0);
        if (batchCountValue == 0) {
            batchCountValue = environmentVariables.getPropertyAsInteger(ThucydidesSystemProperty.BATCH_COUNT.getPropertyName(), (Integer)0);
        }
        return batchCountValue;
    }

    @Override
    public int getCurrentTestCaseNumber() {
        return this.testCaseCount.get();
    }

    @Override
    public void registerTestCase(Class<?> klass) {
        String testCaseName = klass.getName();
        this.registerTestCaseIfNew(testCaseName);
    }

    @Override
    public void registerTestCase(String testCaseName) {
        this.registerTestCaseIfNew(testCaseName);
    }

    private synchronized void registerTestCaseIfNew(String testCaseName) {
        if (!this.registeredTestCases.contains(testCaseName)) {
            this.registeredTestCases.add(testCaseName);
            this.testCaseCount.getAndIncrement();
        }
    }

    @Override
    public boolean shouldExecuteThisTest() {
        if (this.batchCount > 0) {
            return this.testCaseCount.get() % this.batchCount == this.batchNumber % this.batchCount;
        }
        return true;
    }
}

