/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.xml.XMLTestOutcomeReporter;

public class TestOutcomeLoader {
    public List<TestOutcome> loadFrom(File reportDirectory) throws IOException {
        XMLTestOutcomeReporter testOutcomeReporter = new XMLTestOutcomeReporter();
        List<File> reportFiles = this.getAllXMLFilesFrom(reportDirectory);
        ArrayList testOutcomes = Lists.newArrayList();
        for (File reportFile : reportFiles) {
            Optional<TestOutcome> testOutcome = testOutcomeReporter.loadReportFrom(reportFile);
            testOutcomes.addAll(testOutcome.asSet());
        }
        return ImmutableList.copyOf((Collection)testOutcomes);
    }

    private List<File> getAllXMLFilesFrom(File reportsDirectory) throws IOException {
        Object[] matchingFiles = reportsDirectory.listFiles(new XmlFilenameFilter());
        if (matchingFiles == null) {
            throw new IOException("Could not find directory " + reportsDirectory);
        }
        return ImmutableList.copyOf((Object[])matchingFiles);
    }

    public static TestOutcomes testOutcomesIn(File reportsDirectory) throws IOException {
        TestOutcomeLoader loader = new TestOutcomeLoader();
        return TestOutcomes.of(loader.loadFrom(reportsDirectory));
    }

    private static final class XmlFilenameFilter
    implements FilenameFilter {
        private XmlFilenameFilter() {
        }

        @Override
        public boolean accept(File file, String filename) {
            return filename.toLowerCase(Locale.getDefault()).endsWith(".xml");
        }
    }
}

