/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model;

import com.google.common.base.Optional;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.requirements.model.Narrative;

public class NarrativeReader {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String TITLE_SEPARATOR = ":";
    private final IssueTracking issueTracking = (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class);

    public Optional<Narrative> loadFrom(File directory) {
        File[] narrativeFiles = directory.listFiles(this.endingInNarrative());
        if (narrativeFiles.length == 0) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)this.narrativeLoadedFrom(narrativeFiles[0]));
    }

    private Narrative narrativeLoadedFrom(File narrativeFile) {
        Narrative narrative = null;
        String type = this.withoutFileExtension(narrativeFile.getName());
        try {
            BufferedReader reader = new BufferedReader(new FileReader(narrativeFile));
            String title = null;
            String cardNumber = null;
            Optional<String> titleLine = this.readOptionalTitleLine(reader);
            if (titleLine.isPresent()) {
                title = this.readTitleFrom((String)titleLine.get());
                cardNumber = this.findCardNumberIn((String)titleLine.get());
            }
            String text = this.readDescriptionFrom(reader);
            reader.close();
            narrative = new Narrative((Optional<String>)Optional.fromNullable((Object)title), (Optional<String>)Optional.fromNullable((Object)cardNumber), type, text);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return narrative;
    }

    private Optional<String> readOptionalTitleLine(BufferedReader reader) throws IOException {
        String titleLine = reader.readLine();
        if (titleLine.contains(TITLE_SEPARATOR)) {
            return Optional.of((Object)titleLine);
        }
        return Optional.absent();
    }

    private String findCardNumberIn(String titleLine) {
        List<String> issues = Formatter.issuesIn(titleLine);
        if (!issues.isEmpty()) {
            return issues.get(0);
        }
        return null;
    }

    private String withoutFileExtension(String name) {
        int fileExtensionIndex = name.indexOf(".");
        return name.substring(0, fileExtensionIndex);
    }

    private String readTitleFrom(String titleLine) throws IOException {
        int separatorAt = titleLine.indexOf(TITLE_SEPARATOR);
        if (separatorAt > 0) {
            return titleLine.substring(separatorAt + 1).trim();
        }
        return null;
    }

    private String readDescriptionFrom(BufferedReader reader) throws IOException {
        String line;
        StringBuilder description = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            description.append(line);
            description.append(NEW_LINE);
        }
        return description.toString();
    }

    private FilenameFilter endingInNarrative() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.toLowerCase().endsWith(".narrative");
            }
        };
    }
}

