/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reflection;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFinder {
    private final ClassLoader classLoader;
    private final Class annotation;

    private ClassFinder(ClassLoader classLoader, Class annotation) {
        this.classLoader = classLoader;
        this.annotation = annotation;
    }

    private ClassFinder(ClassLoader classLoader) {
        this(classLoader, null);
    }

    public static ClassFinder loadClasses() {
        return new ClassFinder(ClassFinder.getDefaultClassLoader());
    }

    public ClassFinder withClassLoader(ClassLoader classLoader) {
        return new ClassFinder(classLoader);
    }

    public ClassFinder annotatedWith(Class annotation) {
        return new ClassFinder(this.classLoader, annotation);
    }

    public List<Class<?>> fromPackage(String packageName) {
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = this.classResourcesOn(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList classes = new ArrayList();
        for (File directory : dirs) {
            classes.addAll(this.findClasses(directory, packageName));
        }
        return this.filtered(classes);
    }

    private List<Class<?>> filtered(List<Class<?>> classes) {
        ArrayList matchingClasses = new ArrayList();
        for (Class<?> clazz : classes) {
            if (!this.matchesConstraints(clazz)) continue;
            matchingClasses.add(clazz);
        }
        return matchingClasses;
    }

    private boolean matchesConstraints(Class clazz) {
        if (this.annotation == null) {
            return true;
        }
        return clazz.getAnnotation(this.annotation) != null;
    }

    private Enumeration<URL> classResourcesOn(String path) {
        try {
            return this.getClassLoader().getResources(path);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not access class path at " + path, e);
        }
    }

    private List<Class<?>> findClasses(File directory, String packageName) {
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    classes.addAll(this.findClasses(file, packageName + "." + file.getName()));
                    continue;
                }
                if (!file.getName().endsWith(".class") || !this.isNotAnInnerClass(file.getName())) continue;
                classes.add(this.correspondingClass(packageName, file));
            }
        }
        return classes;
    }

    private Class<?> correspondingClass(String packageName, File file) {
        try {
            String fullyQualifiedClassName = packageName + '.' + this.simpleClassNameOf(file);
            return this.getClassLoader().loadClass(fullyQualifiedClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find or access class for " + file, e);
        }
    }

    private static ClassLoader getDefaultClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private String simpleClassNameOf(File file) {
        return file.getName().substring(0, file.getName().length() - 6);
    }

    private boolean isNotAnInnerClass(String className) {
        return !className.contains("$");
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

