/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.NameConverter;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.DisplayedElementLocatorFactory;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.UnsupportedDriverException;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.WebdriverInstanceFactory;
import net.thucydides.core.webdriver.firefox.FirefoxProfileEnhancer;
import net.thucydides.core.webdriver.javascript.JavascriptSupport;
import org.apache.commons.lang.StringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.UnableToCreateProfileException;
import org.openqa.selenium.firefox.internal.ProfilesIni;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDriverFactory {
    public static final String DEFAULT_DRIVER = "firefox";
    private final WebdriverInstanceFactory webdriverInstanceFactory;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDriverFactory.class);
    private ProfilesIni allProfiles;
    private static final int DEFAULT_HEIGHT = 700;
    private static final int DEFAULT_WIDTH = 960;
    private final EnvironmentVariables environmentVariables;
    private final FirefoxProfileEnhancer firefoxProfileEnhancer;

    public WebDriverFactory() {
        this(new WebdriverInstanceFactory(), (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    public WebDriverFactory(EnvironmentVariables environmentVariables) {
        this(new WebdriverInstanceFactory(), environmentVariables);
    }

    public WebDriverFactory(WebdriverInstanceFactory webdriverInstanceFactory, EnvironmentVariables environmentVariables) {
        this(webdriverInstanceFactory, environmentVariables, new FirefoxProfileEnhancer(environmentVariables));
    }

    public WebDriverFactory(WebdriverInstanceFactory webdriverInstanceFactory, EnvironmentVariables environmentVariables, FirefoxProfileEnhancer firefoxProfileEnhancer) {
        this.webdriverInstanceFactory = webdriverInstanceFactory;
        this.environmentVariables = environmentVariables;
        this.firefoxProfileEnhancer = firefoxProfileEnhancer;
    }

    protected ProfilesIni getAllProfiles() {
        if (this.allProfiles == null) {
            this.allProfiles = new ProfilesIni();
        }
        return this.allProfiles;
    }

    public WebDriver newInstanceOf(SupportedWebDriver driverType) {
        if (driverType == null) {
            throw new IllegalArgumentException("Driver type cannot be null");
        }
        return this.newWebdriverInstance(driverType.getWebdriverClass());
    }

    public Class<? extends WebDriver> getClassFor(SupportedWebDriver driverType) {
        if (this.usesSauceLabs() && driverType != SupportedWebDriver.HTMLUNIT) {
            return RemoteWebDriver.class;
        }
        return driverType.getWebdriverClass();
    }

    public boolean usesSauceLabs() {
        return org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)ThucydidesSystemProperty.SAUCELABS_URL.from(this.environmentVariables));
    }

    protected synchronized WebDriver newWebdriverInstance(Class<? extends WebDriver> driverClass) {
        try {
            WebDriver driver = this.isARemoteDriver(driverClass) || this.shouldUseARemoteDriver() ? this.newRemoteDriver() : (this.isAFirefoxDriver(driverClass) ? this.firefoxDriverFrom(driverClass) : (this.isAnHtmlUnitDriver(driverClass) ? this.htmlunitDriverFrom(driverClass) : (this.isAChromeDriver(driverClass) ? this.chromeDriverFrom(driverClass) : this.newDriverInstanceFrom(driverClass))));
            this.setImplicitTimeoutsIfSpecified(driver);
            this.redimensionBrowser(driver);
            JavascriptSupport.activateJavascriptSupportFor(driver);
            return driver;
        }
        catch (Exception cause) {
            throw new UnsupportedDriverException("Could not instantiate " + driverClass, cause);
        }
    }

    private void setImplicitTimeoutsIfSpecified(WebDriver driver) {
        if (ThucydidesSystemProperty.TIMEOUTS_IMPLICIT_WAIT.isDefinedIn(this.environmentVariables)) {
            int timeout = this.environmentVariables.getPropertyAsInteger(ThucydidesSystemProperty.TIMEOUTS_IMPLICIT_WAIT.getPropertyName(), (Integer)0);
            driver.manage().timeouts().implicitlyWait((long)timeout, TimeUnit.MILLISECONDS);
        }
    }

    private boolean shouldUseARemoteDriver() {
        return ThucydidesSystemProperty.REMOTE_URL.isDefinedIn(this.environmentVariables);
    }

    private WebDriver newDriverInstanceFrom(Class<? extends WebDriver> driverClass) throws IllegalAccessException, InstantiationException {
        return this.webdriverInstanceFactory.newInstanceOf(driverClass);
    }

    private WebDriver newRemoteDriver() throws MalformedURLException {
        WebDriver driver = null;
        driver = this.saucelabsUrlIsDefined() ? this.buildSaucelabsDriver() : this.buildRemoteDriver();
        Augmenter augmenter = new Augmenter();
        return augmenter.augment(driver);
    }

    private WebDriver buildRemoteDriver() throws MalformedURLException {
        String remoteUrl = ThucydidesSystemProperty.REMOTE_URL.from(this.environmentVariables);
        DesiredCapabilities capabilities = this.buildCapabilities();
        return new RemoteWebDriver(new URL(remoteUrl), (Capabilities)capabilities);
    }

    private boolean saucelabsUrlIsDefined() {
        return ThucydidesSystemProperty.SAUCELABS_URL.isDefinedIn(this.environmentVariables);
    }

    private WebDriver buildSaucelabsDriver() throws MalformedURLException {
        String saucelabsUrl = ThucydidesSystemProperty.SAUCELABS_URL.from(this.environmentVariables);
        RemoteWebDriver driver = new RemoteWebDriver(new URL(saucelabsUrl), (Capabilities)this.findSaucelabsCapabilities());
        if (StringUtils.isNotEmpty((String)ThucydidesSystemProperty.SAUCELABS_IMPLICIT_TIMEOUT.from(this.environmentVariables))) {
            int implicitWait = this.environmentVariables.getPropertyAsInteger(ThucydidesSystemProperty.SAUCELABS_IMPLICIT_TIMEOUT.getPropertyName(), (Integer)30);
            driver.manage().timeouts().implicitlyWait((long)implicitWait, TimeUnit.SECONDS);
        }
        return driver;
    }

    private DesiredCapabilities findSaucelabsCapabilities() {
        String driver = ThucydidesSystemProperty.DRIVER.from(this.environmentVariables);
        DesiredCapabilities capabilities = this.capabilitiesForDriver(driver);
        this.configureBrowserVersion(capabilities);
        this.configureTargetPlatform(capabilities);
        this.configureTestName(capabilities);
        capabilities.setJavascriptEnabled(true);
        return capabilities;
    }

    private void configureBrowserVersion(DesiredCapabilities capabilities) {
        String driverVersion = ThucydidesSystemProperty.SAUCELABS_DRIVER_VERSION.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((String)driverVersion)) {
            capabilities.setCapability("version", driverVersion);
        }
    }

    private void configureTargetPlatform(DesiredCapabilities capabilities) {
        String platformValue = ThucydidesSystemProperty.SAUCELABS_TARGET_PLATFORM.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((String)platformValue)) {
            capabilities.setCapability("platform", this.platformFrom(platformValue));
        }
    }

    private void configureTestName(DesiredCapabilities capabilities) {
        String testName = ThucydidesSystemProperty.SAUCELABS_TEST_NAME.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((String)testName)) {
            capabilities.setCapability("name", testName);
        } else {
            String guessedTestName = this.bestGuessOfTestName();
            if (guessedTestName != null) {
                capabilities.setCapability("name", this.bestGuessOfTestName());
            }
        }
    }

    private String bestGuessOfTestName() {
        for (StackTraceElement elt : Thread.currentThread().getStackTrace()) {
            try {
                Class<?> callingClass = Class.forName(elt.getClassName());
                Method callingMethod = callingClass.getMethod(elt.getMethodName(), new Class[0]);
                if (this.isATestMethod(callingMethod)) {
                    return NameConverter.humanize(elt.getMethodName());
                }
                if (!this.isASetupMethod(callingMethod)) continue;
                return NameConverter.humanize(callingClass.getSimpleName());
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean isATestMethod(Method callingMethod) {
        return callingMethod.getAnnotation(Test.class) != null;
    }

    private boolean isASetupMethod(Method callingMethod) {
        return callingMethod.getAnnotation(Before.class) != null || callingMethod.getAnnotation(BeforeClass.class) != null;
    }

    private Platform platformFrom(String platformValue) {
        return Platform.valueOf((String)platformValue.toUpperCase());
    }

    private DesiredCapabilities buildCapabilities() {
        String driver = ThucydidesSystemProperty.DRIVER.from(this.environmentVariables);
        return this.capabilitiesForDriver(driver);
    }

    private DesiredCapabilities capabilitiesForDriver(String driver) {
        if (driver == null) {
            driver = DEFAULT_DRIVER;
        }
        SupportedWebDriver driverType = SupportedWebDriver.valueOf(driver.toUpperCase());
        switch (driverType) {
            case CHROME: {
                return DesiredCapabilities.chrome();
            }
            case FIREFOX: {
                return DesiredCapabilities.firefox();
            }
            case HTMLUNIT: {
                return DesiredCapabilities.htmlUnit();
            }
            case OPERA: {
                return DesiredCapabilities.opera();
            }
            case IEXPLORER: {
                return DesiredCapabilities.internetExplorer();
            }
        }
        throw new IllegalArgumentException("Unsupported remote driver type: " + driver);
    }

    private WebDriver htmlunitDriverFrom(Class<? extends WebDriver> driverClass) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        DesiredCapabilities caps = DesiredCapabilities.firefox();
        caps.setJavascriptEnabled(true);
        return new HtmlUnitDriver((Capabilities)caps);
    }

    private WebDriver firefoxDriverFrom(Class<? extends WebDriver> driverClass) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        FirefoxProfile profile = this.buildFirefoxProfile();
        if (this.aProfileCouldBeCreated(profile)) {
            return this.webdriverInstanceFactory.newInstanceOf(driverClass, profile);
        }
        return this.newDriverInstanceFrom(driverClass);
    }

    private WebDriver chromeDriverFrom(Class<? extends WebDriver> driverClass) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        ChromeOptions options = new ChromeOptions();
        String chromeSwitches = this.environmentVariables.getProperty(ThucydidesSystemProperty.CHROME_SWITCHES);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)chromeSwitches)) {
            ArrayList arguments = Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)chromeSwitches));
            options.addArguments((List)arguments);
        }
        return this.webdriverInstanceFactory.newInstanceOf(driverClass, options);
    }

    private boolean aProfileCouldBeCreated(FirefoxProfile profile) {
        return profile != null;
    }

    private Dimension getRequestedBrowserSize() {
        int height = this.environmentVariables.getPropertyAsInteger(ThucydidesSystemProperty.SNAPSHOT_HEIGHT, (Integer)700);
        int width = this.environmentVariables.getPropertyAsInteger(ThucydidesSystemProperty.SNAPSHOT_WIDTH, (Integer)960);
        return new Dimension(width, height);
    }

    private void redimensionBrowser(WebDriver driver) {
        if (this.supportsScreenResizing(driver) && this.broswerDimensionsSpecified()) {
            this.resizeBrowserTo(driver, this.getRequestedBrowserSize().height, this.getRequestedBrowserSize().width);
        }
    }

    private boolean broswerDimensionsSpecified() {
        String snapshotWidth = this.environmentVariables.getProperty(ThucydidesSystemProperty.SNAPSHOT_WIDTH);
        String snapshotHeight = this.environmentVariables.getProperty(ThucydidesSystemProperty.SNAPSHOT_HEIGHT);
        return snapshotWidth != null || snapshotHeight != null;
    }

    private boolean supportsScreenResizing(WebDriver driver) {
        return this.isNotAMocked(driver) && !this.isAnHtmlUnitDriver(this.getDriverClass(driver));
    }

    private boolean isNotAMocked(WebDriver driver) {
        return !driver.getClass().getName().contains("Mock");
    }

    protected void resizeBrowserTo(WebDriver driver, int height, int width) {
        LOGGER.info("Setting browser dimensions to {}/{}", (Object)height, (Object)width);
        if (this.usesFirefox(driver) || this.usesInternetExplorer(driver)) {
            driver.manage().window().setSize(new Dimension(width, height));
        } else if (this.usesChrome(driver)) {
            ((JavascriptExecutor)driver).executeScript("window.open('about:blank','_blank','width=#{width},height=#{height}');", new Object[0]);
            Set windowHandles = driver.getWindowHandles();
            windowHandles.remove(driver.getWindowHandle());
            String newWindowHandle = windowHandles.toArray(new String[0])[0];
            driver.switchTo().window(newWindowHandle);
        }
        String resizeWindow = "window.resizeTo(" + width + "," + height + ")";
        ((JavascriptExecutor)driver).executeScript(resizeWindow, new Object[0]);
    }

    private boolean isARemoteDriver(Class<? extends WebDriver> driverClass) {
        return RemoteWebDriver.class == driverClass;
    }

    private boolean isAFirefoxDriver(Class<? extends WebDriver> driverClass) {
        return FirefoxDriver.class.isAssignableFrom(driverClass);
    }

    private boolean isAChromeDriver(Class<? extends WebDriver> driverClass) {
        return ChromeDriver.class.isAssignableFrom(driverClass);
    }

    private boolean usesFirefox(WebDriver driver) {
        return FirefoxDriver.class.isAssignableFrom(this.getDriverClass(driver));
    }

    private boolean usesInternetExplorer(WebDriver driver) {
        return InternetExplorerDriver.class.isAssignableFrom(this.getDriverClass(driver));
    }

    private boolean usesChrome(WebDriver driver) {
        return ChromeDriver.class.isAssignableFrom(this.getDriverClass(driver));
    }

    private Class getDriverClass(WebDriver driver) {
        Class<Object> driverClass = null;
        driverClass = driver instanceof WebDriverFacade ? ((WebDriverFacade)driver).getDriverClass() : driver.getClass();
        return driverClass;
    }

    private boolean isAnHtmlUnitDriver(Class<? extends WebDriver> driverClass) {
        return HtmlUnitDriver.class.isAssignableFrom(driverClass);
    }

    private boolean isAnInternetExplorerDriver(Class<? extends WebDriver> driverClass) {
        return InternetExplorerDriver.class.isAssignableFrom(driverClass);
    }

    protected FirefoxProfile createNewFirefoxProfile() {
        FirefoxProfile profile = new FirefoxProfile();
        profile.setAlwaysLoadNoFocusLib(true);
        profile.setEnableNativeEvents(true);
        return profile;
    }

    protected FirefoxProfile useExistingFirefoxProfile(File profileDirectory) {
        return new FirefoxProfile(profileDirectory);
    }

    private FirefoxProfile buildFirefoxProfile() {
        FirefoxProfile profile = null;
        try {
            String profileName = this.environmentVariables.getProperty("webdriver.firefox.profile");
            profile = profileName == null ? this.createNewFirefoxProfile() : this.getProfileFrom(profileName);
            this.firefoxProfileEnhancer.allowWindowResizeFor(profile);
            if (this.shouldEnableNativeEvents()) {
                this.firefoxProfileEnhancer.enableNativeEventsFor(profile);
            }
            if (this.shouldActivateProxy()) {
                this.activateProxyFor(profile, this.firefoxProfileEnhancer);
            }
            if (this.firefoxProfileEnhancer.shouldActivateFirebugs()) {
                LOGGER.info("Adding Firebugs to Firefox profile");
                this.firefoxProfileEnhancer.addFirebugsTo(profile);
            }
            if (this.dontAssumeUntrustedCertificateIssuer()) {
                profile.setAssumeUntrustedCertificateIssuer(false);
                profile.setAcceptUntrustedCertificates(true);
            }
        }
        catch (UnableToCreateProfileException unableToCreateProfileException) {
            // empty catch block
        }
        return profile;
    }

    private boolean shouldEnableNativeEvents() {
        return Boolean.valueOf(ThucydidesSystemProperty.NATIVE_EVENTS.from(this.environmentVariables, "true"));
    }

    private void activateProxyFor(FirefoxProfile profile, FirefoxProfileEnhancer firefoxProfileEnhancer) {
        String proxyUrl = this.getProxyUrlFromEnvironmentVariables();
        String proxyPort = this.getProxyPortFromEnvironmentVariables();
        firefoxProfileEnhancer.activateProxy(profile, proxyUrl, proxyPort);
    }

    private String getProxyPortFromEnvironmentVariables() {
        return this.environmentVariables.getProperty(ThucydidesSystemProperty.PROXY_PORT.getPropertyName());
    }

    private boolean shouldActivateProxy() {
        String proxyUrl = this.getProxyUrlFromEnvironmentVariables();
        return org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)proxyUrl);
    }

    private String getProxyUrlFromEnvironmentVariables() {
        return this.environmentVariables.getProperty(ThucydidesSystemProperty.PROXY_URL.getPropertyName());
    }

    private FirefoxProfile getProfileFrom(String profileName) {
        FirefoxProfile profile = this.getAllProfiles().getProfile(profileName);
        if (profile == null) {
            profile = this.useExistingFirefoxProfile(new File(profileName));
        }
        return profile;
    }

    private boolean dontAssumeUntrustedCertificateIssuer() {
        return this.environmentVariables.getPropertyAsBoolean(ThucydidesSystemProperty.ASSUME_UNTRUSTED_CERTIFICATE_ISSUER.getPropertyName(), true) == false;
    }

    public static void initElementsWithAjaxSupport(Object pageObject, WebDriver driver) {
        Configuration configuration = (Configuration)Injectors.getInjector().getInstance(Configuration.class);
        int elementTimeoutInSeconds = configuration.getElementTimeout();
        DisplayedElementLocatorFactory finder = new DisplayedElementLocatorFactory(driver, elementTimeoutInSeconds);
        PageFactory.initElements((ElementLocatorFactory)finder, (Object)pageObject);
    }

    public static void initElementsWithAjaxSupport(Object pageObject, WebDriver driver, int timeoutInSeconds) {
        DisplayedElementLocatorFactory finder = new DisplayedElementLocatorFactory(driver, timeoutInSeconds);
        PageFactory.initElements((ElementLocatorFactory)finder, (Object)pageObject);
    }
}

